/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.parsing;

import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;

public class EqualityVisitor
implements ASTVisitor {
    private ASTNode node1;
    private ASTNode node2;
    private boolean isEqual;

    private EqualityVisitor(ASTNode node1, ASTNode node2) {
        this.node1 = node1;
        this.node2 = node2;
    }

    private boolean checkEquality() {
        this.node1.accept(this);
        return this.isEqual;
    }

    public static boolean compare(ASTNode node1, ASTNode node2) {
        EqualityVisitor visitor = new EqualityVisitor(node1, node2);
        return visitor.checkEquality();
    }

    public void visitActionTypeNode(ActionTypeNode node) {
        if (!(this.node2 instanceof ActionTypeNode)) {
            this.isEqual = false;
            return;
        }
        ActionTypeNode otherNode = (ActionTypeNode)this.node2;
        this.isEqual = node.getType().equals(otherNode.getType());
    }

    public void visitActivityNode(ActivityNode node) {
        if (!(this.node2 instanceof ActivityNode)) {
            this.isEqual = false;
            return;
        }
        ActivityNode otherNode = (ActivityNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getAction(), otherNode.getAction());
        boolean compare2 = EqualityVisitor.compare(node.getRate(), otherNode.getRate());
        this.isEqual = compare1 && compare2;
    }

    public void visitAggregationNode(AggregationNode node) {
        if (!(this.node2 instanceof AggregationNode)) {
            this.isEqual = false;
            return;
        }
        AggregationNode otherNode = (AggregationNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getProcessNode(), otherNode.getProcessNode());
        boolean compare2 = EqualityVisitor.compare(node.getCopies(), otherNode.getCopies());
        this.isEqual = compare1 && compare2;
    }

    public void visitBinaryOperatorRateNode(BinaryOperatorRateNode node) {
        if (!(this.node2 instanceof BinaryOperatorRateNode)) {
            this.isEqual = false;
            return;
        }
        BinaryOperatorRateNode otherNode = (BinaryOperatorRateNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getLeft(), otherNode.getLeft());
        boolean compare2 = EqualityVisitor.compare(node.getRight(), otherNode.getRight());
        boolean compare3 = node.getOperator().name.equals(otherNode.getOperator().name);
        this.isEqual = compare1 && compare2 && compare3;
    }

    public void visitChoiceNode(ChoiceNode node) {
        if (!(this.node2 instanceof ChoiceNode)) {
            this.isEqual = false;
            return;
        }
        ChoiceNode otherNode = (ChoiceNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getLeft(), otherNode.getLeft());
        boolean compare2 = EqualityVisitor.compare(node.getRight(), otherNode.getRight());
        this.isEqual = compare1 && compare2;
    }

    public void visitConstantProcessNode(ConstantProcessNode node) {
        if (!(this.node2 instanceof ConstantProcessNode)) {
            this.isEqual = false;
            return;
        }
        ConstantProcessNode otherNode = (ConstantProcessNode)this.node2;
        this.isEqual = node.getName().equals(otherNode.getName());
    }

    public void visitCooperationNode(CooperationNode node) {
        if (!(this.node2 instanceof CooperationNode)) {
            this.isEqual = false;
            return;
        }
        CooperationNode otherNode = (CooperationNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getLeft(), otherNode.getLeft());
        boolean compare2 = EqualityVisitor.compare(node.getRight(), otherNode.getRight());
        boolean compare3 = node.getActionSet().size() == otherNode.getActionSet().size();
        this.isEqual = compare1 && compare2 && compare3;
        int i = 0;
        while (i < node.getActionSet().size()) {
            this.isEqual = this.isEqual && EqualityVisitor.compare((ASTNode)node.getActionSet().get(i), (ASTNode)otherNode.getActionSet().get(i));
            ++i;
        }
    }

    public void visitHidingNode(HidingNode node) {
        if (!(this.node2 instanceof HidingNode)) {
            this.isEqual = false;
            return;
        }
        HidingNode otherNode = (HidingNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getProcess(), otherNode.getProcess());
        boolean compare2 = node.getActionSet().size() == otherNode.getActionSet().size();
        this.isEqual = compare1 && compare2;
        int i = 0;
        while (i < node.getActionSet().size()) {
            this.isEqual = this.isEqual && EqualityVisitor.compare((ASTNode)node.getActionSet().get(i), (ASTNode)otherNode.getActionSet().get(i));
            ++i;
        }
    }

    public void visitModelNode(ModelNode node) {
        if (!(this.node2 instanceof ModelNode)) {
            this.isEqual = false;
            return;
        }
        ModelNode otherNode = (ModelNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getSystemEquation(), otherNode.getSystemEquation());
        boolean compare2 = node.rateDefinitions().size() == otherNode.rateDefinitions().size();
        boolean compare3 = node.processDefinitions().size() == otherNode.processDefinitions().size();
        this.isEqual = compare1 && compare2 && compare3;
        int i = 0;
        while (i < node.rateDefinitions().size()) {
            this.isEqual = this.isEqual && EqualityVisitor.compare((ASTNode)node.rateDefinitions().get(i), (ASTNode)otherNode.rateDefinitions().get(i));
            ++i;
        }
        i = 0;
        while (i < node.processDefinitions().size()) {
            this.isEqual = this.isEqual && EqualityVisitor.compare((ASTNode)node.processDefinitions().get(i), (ASTNode)otherNode.processDefinitions().get(i));
            ++i;
        }
    }

    public void visitPassiveRateNode(PassiveRateNode node) {
        if (!(this.node2 instanceof PassiveRateNode)) {
            this.isEqual = false;
            return;
        }
        PassiveRateNode otherNode = (PassiveRateNode)this.node2;
        this.isEqual = node.getMultiplicity() == otherNode.getMultiplicity();
    }

    public void visitPrefixNode(PrefixNode node) {
        if (!(this.node2 instanceof PrefixNode)) {
            this.isEqual = false;
            return;
        }
        PrefixNode otherNode = (PrefixNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getActivity(), otherNode.getActivity());
        boolean compare2 = EqualityVisitor.compare(node.getTarget(), otherNode.getTarget());
        this.isEqual = compare1 && compare2;
    }

    public void visitProcessDefinitionNode(ProcessDefinitionNode node) {
        if (!(this.node2 instanceof ProcessDefinitionNode)) {
            this.isEqual = false;
            return;
        }
        ProcessDefinitionNode otherNode = (ProcessDefinitionNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getNode(), otherNode.getNode());
        boolean compare2 = EqualityVisitor.compare(node.getName(), otherNode.getName());
        this.isEqual = compare1 && compare2;
    }

    public void visitRateDefinitionNode(RateDefinitionNode node) {
        if (!(this.node2 instanceof RateDefinitionNode)) {
            this.isEqual = false;
            return;
        }
        RateDefinitionNode otherNode = (RateDefinitionNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getRate(), otherNode.getRate());
        boolean compare2 = EqualityVisitor.compare(node.getName(), otherNode.getName());
        this.isEqual = compare1 && compare2;
    }

    public void visitRateDoubleNode(RateDoubleNode node) {
        if (!(this.node2 instanceof RateDoubleNode)) {
            this.isEqual = false;
            return;
        }
        RateDoubleNode otherNode = (RateDoubleNode)this.node2;
        this.isEqual = node.getValue() == otherNode.getValue();
    }

    public void visitUnknownActionTypeNode(UnknownActionTypeNode node) {
        if (!(this.node2 instanceof UnknownActionTypeNode)) {
            this.isEqual = false;
        }
        this.isEqual = true;
    }

    public void visitVariableRateNode(VariableRateNode node) {
        if (!(this.node2 instanceof VariableRateNode)) {
            this.isEqual = false;
            return;
        }
        VariableRateNode otherNode = (VariableRateNode)this.node2;
        this.isEqual = node.getName().equals(otherNode.getName());
    }

    public void visitWildcardCooperationNode(WildcardCooperationNode node) {
        if (!(this.node2 instanceof WildcardCooperationNode)) {
            this.isEqual = false;
            return;
        }
        WildcardCooperationNode otherNode = (WildcardCooperationNode)this.node2;
        boolean compare1 = EqualityVisitor.compare(node.getLeft(), otherNode.getLeft());
        boolean compare2 = EqualityVisitor.compare(node.getRight(), otherNode.getRight());
        this.isEqual = compare1 && compare2;
    }
}

