/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.parsing;

import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.model.NamedRate;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;

public class ExpressionVisitor
implements ASTVisitor {
    private double eval = 0.0;
    private Model model;

    public ExpressionVisitor(Model model) {
        this.model = model;
    }

    public int eval() {
        if (Math.floor(this.eval) == this.eval) {
            return (int)this.eval;
        }
        throw new IllegalStateException("Expected integer");
    }

    public void visitActionTypeNode(ActionTypeNode actionType) {
        throw new IllegalStateException();
    }

    public void visitActivityNode(ActivityNode activity) {
        throw new IllegalStateException();
    }

    public void visitAggregationNode(AggregationNode aggregation) {
        throw new IllegalStateException();
    }

    public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
        ExpressionVisitor vl = new ExpressionVisitor(this.model);
        rate.getLeft().accept(vl);
        ExpressionVisitor vr = new ExpressionVisitor(this.model);
        rate.getRight().accept(vr);
        if (rate.getOperator() == BinaryOperatorRateNode.Operator.PLUS) {
            this.eval = vl.eval() + vr.eval();
        } else if (rate.getOperator() == BinaryOperatorRateNode.Operator.MINUS) {
            this.eval = vl.eval() - vr.eval();
        } else if (rate.getOperator() == BinaryOperatorRateNode.Operator.DIV) {
            this.eval = vl.eval() / vr.eval();
        } else if (rate.getOperator() == BinaryOperatorRateNode.Operator.MULT) {
            this.eval = vl.eval() * vr.eval();
        }
    }

    public void visitChoiceNode(ChoiceNode choice) {
        throw new IllegalStateException();
    }

    public void visitConstantProcessNode(ConstantProcessNode constant) {
        throw new IllegalStateException();
    }

    public void visitCooperationNode(CooperationNode cooperation) {
        throw new IllegalStateException();
    }

    public void visitHidingNode(HidingNode hiding) {
        throw new IllegalStateException();
    }

    public void visitModelNode(ModelNode model) {
        throw new IllegalStateException();
    }

    public void visitPassiveRateNode(PassiveRateNode passive) {
        throw new IllegalStateException();
    }

    public void visitPrefixNode(PrefixNode prefix) {
        throw new IllegalStateException();
    }

    public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
        throw new IllegalStateException();
    }

    public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
        throw new IllegalStateException();
    }

    public void visitRateDoubleNode(RateDoubleNode doubleRate) {
        this.eval = doubleRate.getValue();
    }

    public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
        throw new IllegalStateException();
    }

    public void visitVariableRateNode(VariableRateNode variableRate) {
        for (NamedRate rate : this.model.getRateDefinitions()) {
            if (!rate.getName().equals(variableRate.getName())) continue;
            this.eval = rate.getValue();
            return;
        }
        throw new IllegalStateException();
    }

    public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
        throw new IllegalStateException();
    }
}

