/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.sba;

import java.util.Map;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.Value;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.RateNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.sba.SBAComponent;
import uk.ac.ed.inf.pepa.sba.VEVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledRate
implements Cloneable {
    private static final int precision = 5;
    private static PassiveRateVisitor prv = new PassiveRateVisitor();
    private static RatesVisitor rv = new RatesVisitor();
    private static StringVisitor sv = new StringVisitor();
    private Expression.Element element;
    private StringBuilder textualForm = new StringBuilder();
    private BinaryOperatorRateNode.Operator lastOp = null;
    private double numerator = Double.NaN;
    private double denominator = 1.0;
    private int opIndex;

    public static synchronized CompiledRate compileRate(RateNode rateNode, Map<String, RateNode> rates) {
        CompiledRate.rv.sbaRates = rates;
        rateNode.accept(rv);
        CompiledRate compiledRate = new CompiledRate();
        if (!Double.isNaN(CompiledRate.rv.lastRate)) {
            compiledRate.numerator = CompiledRate.rv.lastRate;
        } else {
            compiledRate.lastOp = CompiledRate.rv.currentOp;
        }
        compiledRate.textualForm = CompiledRate.rv.textualForm;
        compiledRate.element = CompiledRate.rv.element;
        return compiledRate;
    }

    public static synchronized CompiledRate passive(SBAComponent component) {
        int i = prv.getWeight(component.rate);
        if (i == -1) {
            return null;
        }
        CompiledRate c = new CompiledRate(i);
        c = c.op(BinaryOperatorRateNode.Operator.MULT, new CompiledRate(component));
        return c;
    }

    public static synchronized boolean isPassive(SBAComponent component) {
        return prv.getWeight(component.rate) > 0;
    }

    public static synchronized CompiledRate min(CompiledRate first, CompiledRate second) {
        CompiledRate c = new CompiledRate();
        if (first.lastOp != null && first.lastOp.equals((Object)second.lastOp)) {
            String common = null;
            String ul = null;
            String ur = null;
            Expression.Element ce = null;
            Expression.Element te = new Expression.Element(Expression.ElementCode.MIN);
            String ll = first.textualForm.substring(0, first.opIndex);
            String lr = first.textualForm.substring(first.opIndex + 1);
            String rl = second.textualForm.substring(0, second.opIndex);
            String rr = second.textualForm.substring(second.opIndex + 1);
            if (ll.equals(rl)) {
                common = ll;
                ce = (Expression.Element)first.element.mFirstOperand.clone();
                ul = lr;
                te.mFirstOperand = (Expression.Element)first.element.mSecondOperand.clone();
                ur = rr;
                te.mSecondOperand = (Expression.Element)second.element.mSecondOperand.clone();
            } else if (ll.equals(rr)) {
                common = ll;
                ce = (Expression.Element)first.element.mFirstOperand.clone();
                ul = lr;
                te.mFirstOperand = (Expression.Element)first.element.mSecondOperand.clone();
                ur = rl;
                te.mSecondOperand = (Expression.Element)second.element.mFirstOperand.clone();
            } else if (lr.equals(rl)) {
                common = lr;
                ce = (Expression.Element)first.element.mSecondOperand.clone();
                ul = ll;
                te.mFirstOperand = (Expression.Element)first.element.mFirstOperand.clone();
                ur = rr;
                te.mSecondOperand = (Expression.Element)second.element.mSecondOperand.clone();
            } else if (lr.equals(rr)) {
                common = lr;
                ce = (Expression.Element)first.element.mSecondOperand.clone();
                ul = ll;
                te.mFirstOperand = (Expression.Element)first.element.mFirstOperand.clone();
                ur = rl;
                te.mSecondOperand = (Expression.Element)second.element.mFirstOperand.clone();
            }
            if (common != null) {
                c.textualForm.append(common).append((Object)first.lastOp).append("min(");
                c.textualForm.append(ul).append(",").append(ur).append(")");
                c.element = first.lastOp.getElement();
                c.opIndex = common.length();
                c.element.mFirstOperand = ce;
                c.element.mSecondOperand = te;
                c.lastOp = first.lastOp;
                return c;
            }
        }
        c.textualForm.append("min(");
        c.textualForm.append(first.textualForm == null ? Double.valueOf(first.numerator / first.denominator) : first.textualForm);
        c.textualForm.append(",");
        c.textualForm.append(second.textualForm == null ? Double.valueOf(second.numerator / second.denominator) : second.textualForm);
        c.textualForm.append(")");
        if (Double.isNaN(first.numerator) || Double.isNaN(second.numerator)) {
            c.element = new Expression.Element(Expression.ElementCode.MIN);
            c.element.mFirstOperand = (Expression.Element)first.element.clone();
            c.element.mSecondOperand = (Expression.Element)second.element.clone();
        } else {
            c.numerator = Math.min(first.numerator / first.denominator, second.numerator / second.denominator);
            c.element = new Expression.Element(c.numerator);
            if (first.textualForm == null && second.textualForm == null) {
                c.textualForm = null;
            }
        }
        return c;
    }

    public static synchronized CompiledRate pow(CompiledRate compiledRate, double power) {
        CompiledRate c = new CompiledRate();
        if (compiledRate.textualForm != null) {
            c.textualForm.append((CharSequence)compiledRate.textualForm).append("^").append(power);
        } else {
            c.textualForm = null;
        }
        if (Double.isNaN(compiledRate.numerator)) {
            c.element = new Expression.Element(Expression.ElementCode.POW);
            c.element.mFirstOperand = (Expression.Element)compiledRate.element.clone();
            c.element.mSecondOperand = new Expression.Element(power);
        } else {
            c.numerator = Math.pow(compiledRate.numerator / compiledRate.denominator, power);
            c.element = new Expression.Element(c.numerator);
        }
        return c;
    }

    public static synchronized CompiledRate theta(CompiledRate compiledRate) {
        CompiledRate c = new CompiledRate();
        if (compiledRate.textualForm != null) {
            c.textualForm.append("theta(").append((CharSequence)compiledRate.textualForm).append(")");
        } else {
            c.textualForm = null;
        }
        if (Double.isNaN(compiledRate.numerator)) {
            c.element = new Expression.Element(Expression.ElementCode.THETA);
            c.element.mFirstOperand = (Expression.Element)compiledRate.element.clone();
        } else {
            c.numerator = compiledRate.numerator > 0.0 ? 1 : 0;
            c.element = new Expression.Element(c.numerator);
        }
        return c;
    }

    public static synchronized String toString(RateNode rateNode) {
        CompiledRate.sv.sbaRates = null;
        rateNode.accept(sv);
        if (!Double.isNaN(CompiledRate.sv.lastRate)) {
            return Double.toString(CompiledRate.sv.lastRate);
        }
        return CompiledRate.sv.textualForm.toString();
    }

    private CompiledRate() {
    }

    CompiledRate(int value) {
        this.numerator = value;
        this.textualForm = null;
        this.element = new Expression.Element((double)value);
    }

    CompiledRate(SBAComponent component) {
        this.textualForm.append(component.getName());
        this.element = new Expression.Element(Expression.ElementCode.SYMBOL);
        this.element.mSymbol = new Symbol(this.textualForm.toString());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CompiledRate)) {
            return false;
        }
        CompiledRate rate = (CompiledRate)o;
        if (!Double.isNaN(this.numerator) && !Double.isNaN(rate.numerator) && this.numerator != rate.numerator) {
            return false;
        }
        if (this.denominator != rate.denominator) {
            return false;
        }
        return this.textualForm.toString().equals(rate.textualForm.toString());
    }

    public boolean isExpression() {
        return Double.isNaN(this.numerator);
    }

    public boolean isFraction() {
        return !Double.isNaN(this.numerator) && this.denominator != 1.0;
    }

    public CompiledRate op(BinaryOperatorRateNode.Operator operator, CompiledRate rightRate) {
        boolean second;
        String rr;
        String rl;
        String lr;
        String ll;
        CompiledRate newRate = new CompiledRate();
        if (this.textualForm == null && rightRate.textualForm == null) {
            newRate.textualForm = null;
            newRate.numerator = operator.evaluate(this.numerator / this.denominator, rightRate.numerator / rightRate.denominator);
            newRate.element = new Expression.Element(newRate.numerator);
            return newRate;
        }
        if ((operator.equals((Object)BinaryOperatorRateNode.Operator.MINUS) || operator.equals((Object)BinaryOperatorRateNode.Operator.PLUS)) && (BinaryOperatorRateNode.Operator.MULT.equals((Object)this.lastOp) || BinaryOperatorRateNode.Operator.DIV.equals((Object)this.lastOp) && this.lastOp.equals((Object)rightRate.lastOp))) {
            String common = null;
            String ul = null;
            String ur = null;
            Expression.Element ce = null;
            Expression.Element te = operator.getElement();
            ll = this.textualForm.substring(0, this.opIndex);
            lr = this.textualForm.substring(this.opIndex + 1);
            rl = rightRate.textualForm.substring(0, rightRate.opIndex);
            rr = rightRate.textualForm.substring(rightRate.opIndex + 1);
            if (ll.equals(rl)) {
                common = ll;
                ce = (Expression.Element)this.element.mFirstOperand.clone();
                ul = lr;
                te.mFirstOperand = (Expression.Element)this.element.mSecondOperand.clone();
                ur = rr;
                te.mSecondOperand = (Expression.Element)rightRate.element.mSecondOperand.clone();
            } else if (ll.equals(rr)) {
                common = ll;
                ce = (Expression.Element)this.element.mFirstOperand.clone();
                ul = lr;
                te.mFirstOperand = (Expression.Element)this.element.mSecondOperand.clone();
                ur = rl;
                te.mSecondOperand = (Expression.Element)rightRate.element.mFirstOperand.clone();
            } else if (lr.equals(rl)) {
                common = lr;
                ce = (Expression.Element)this.element.mSecondOperand.clone();
                ul = ll;
                te.mFirstOperand = (Expression.Element)this.element.mFirstOperand.clone();
                ur = rr;
                te.mSecondOperand = (Expression.Element)rightRate.element.mSecondOperand.clone();
            } else if (lr.equals(rr)) {
                common = lr;
                ce = (Expression.Element)this.element.mSecondOperand.clone();
                ul = ll;
                te.mFirstOperand = (Expression.Element)this.element.mFirstOperand.clone();
                ur = rl;
                te.mSecondOperand = (Expression.Element)rightRate.element.mFirstOperand.clone();
            }
            if (common != null) {
                newRate.textualForm.append(common).append((Object)this.lastOp).append("(");
                newRate.textualForm.append(ul).append((Object)operator).append(ur);
                newRate.textualForm.append(")");
                newRate.element = this.lastOp.getElement();
                newRate.opIndex = common.length();
                newRate.element.mFirstOperand = ce;
                newRate.element.mSecondOperand = te;
                newRate.lastOp = this.lastOp;
                if (!Double.isNaN(this.numerator) && !Double.isNaN(rightRate.numerator)) {
                    newRate.numerator = operator.evaluate(this.numerator / this.denominator, rightRate.numerator / rightRate.denominator);
                }
                return newRate;
            }
        }
        if (operator.equals((Object)BinaryOperatorRateNode.Operator.DIV) && BinaryOperatorRateNode.Operator.MULT.equals((Object)this.lastOp) && BinaryOperatorRateNode.Operator.MULT.equals((Object)rightRate.lastOp)) {
            String ul = null;
            String ur = null;
            newRate.element = operator.getElement();
            ll = this.textualForm.substring(0, this.opIndex);
            lr = this.textualForm.substring(this.opIndex + 1);
            rl = rightRate.textualForm.substring(0, rightRate.opIndex);
            rr = rightRate.textualForm.substring(rightRate.opIndex + 1);
            if (ll.equals(rl)) {
                ul = lr;
                newRate.element.mFirstOperand = (Expression.Element)this.element.mSecondOperand.clone();
                ur = rr;
                newRate.element.mSecondOperand = (Expression.Element)rightRate.element.mSecondOperand.clone();
            } else if (ll.equals(rr)) {
                ul = lr;
                newRate.element.mFirstOperand = (Expression.Element)this.element.mSecondOperand.clone();
                ur = rl;
                newRate.element.mSecondOperand = (Expression.Element)rightRate.element.mFirstOperand.clone();
            } else if (lr.equals(rl)) {
                ul = ll;
                newRate.element.mFirstOperand = (Expression.Element)this.element.mFirstOperand.clone();
                ur = rr;
                newRate.element.mSecondOperand = (Expression.Element)rightRate.element.mSecondOperand.clone();
            } else if (lr.equals(rr)) {
                ul = ll;
                newRate.element.mFirstOperand = (Expression.Element)this.element.mFirstOperand.clone();
                ur = rl;
                newRate.element.mSecondOperand = (Expression.Element)rightRate.element.mFirstOperand.clone();
            }
            if (ul != null) {
                newRate.textualForm.append(ul).append((Object)operator).append(ur);
                newRate.lastOp = operator;
                newRate.opIndex = ul.length();
                return newRate;
            }
        }
        boolean first = !operator.equals((Object)BinaryOperatorRateNode.Operator.MULT) || Double.isNaN(this.numerator) || this.denominator != this.numerator;
        boolean bl = second = !operator.equals((Object)BinaryOperatorRateNode.Operator.MULT) && !operator.equals((Object)BinaryOperatorRateNode.Operator.DIV) || Double.isNaN(rightRate.numerator) || rightRate.denominator != rightRate.numerator;
        if (first) {
            if (this.textualForm == null) {
                if (this.denominator != 1.0) {
                    newRate.textualForm.append("(").append(this.numerator).append("/").append(this.denominator).append(")");
                } else {
                    newRate.textualForm.append(this.numerator);
                }
            } else if (this.lastOp != null && (this.lastOp.precedence() < operator.precedence() || operator.equals((Object)BinaryOperatorRateNode.Operator.DIV))) {
                newRate.textualForm.append("(").append((CharSequence)this.textualForm).append(")");
            } else {
                newRate.textualForm.append((CharSequence)this.textualForm);
            }
        }
        if (first && second) {
            newRate.opIndex = newRate.textualForm.length();
            newRate.textualForm.append((Object)operator);
            newRate.lastOp = operator;
            newRate.element = operator.getElement();
            newRate.element.mFirstOperand = (Expression.Element)this.element.clone();
            newRate.element.mSecondOperand = (Expression.Element)rightRate.element.clone();
        } else {
            Expression.Element element = newRate.element = first ? (Expression.Element)this.element.clone() : (Expression.Element)rightRate.element.clone();
        }
        if (second) {
            if (rightRate.textualForm == null) {
                if (rightRate.denominator != 1.0) {
                    newRate.textualForm.append("(").append(rightRate.numerator).append("/").append(rightRate.denominator).append(")");
                } else {
                    newRate.textualForm.append(rightRate.numerator);
                }
            } else if (rightRate.lastOp != null && (rightRate.lastOp.precedence() < operator.precedence() || operator.equals((Object)BinaryOperatorRateNode.Operator.DIV))) {
                newRate.textualForm.append("(").append((CharSequence)rightRate.textualForm).append(")");
            } else {
                newRate.textualForm.append((CharSequence)rightRate.textualForm);
            }
        }
        return newRate;
    }

    public CompiledRate stabilisedRatio(CompiledRate denominator) {
        CompiledRate ratio = new CompiledRate();
        ratio.element = BinaryOperatorRateNode.Operator.DIV.getElement();
        String sn = null;
        String sd = null;
        if (BinaryOperatorRateNode.Operator.MULT.equals((Object)this.lastOp) && BinaryOperatorRateNode.Operator.MULT.equals((Object)denominator.lastOp)) {
            String ll = this.textualForm.substring(0, this.opIndex);
            String lr = this.textualForm.substring(this.opIndex + 1);
            String rl = denominator.textualForm.substring(0, denominator.opIndex);
            String rr = denominator.textualForm.substring(denominator.opIndex + 1);
            if (ll.equals(rl)) {
                sn = lr;
                ratio.element.mFirstOperand = (Expression.Element)this.element.mSecondOperand.clone();
                sd = rr;
                ratio.element.mSecondOperand = (Expression.Element)denominator.element.mSecondOperand.clone();
            } else if (ll.equals(rr)) {
                sn = lr;
                ratio.element.mFirstOperand = (Expression.Element)this.element.mSecondOperand.clone();
                sd = rl;
                ratio.element.mSecondOperand = (Expression.Element)denominator.element.mFirstOperand.clone();
            } else if (lr.equals(rl)) {
                sn = ll;
                ratio.element.mFirstOperand = (Expression.Element)this.element.mFirstOperand.clone();
                sd = rr;
                ratio.element.mSecondOperand = (Expression.Element)denominator.element.mSecondOperand.clone();
            } else if (lr.equals(rr)) {
                sn = ll;
                ratio.element.mFirstOperand = (Expression.Element)this.element.mFirstOperand.clone();
                sd = rl;
                ratio.element.mSecondOperand = (Expression.Element)denominator.element.mFirstOperand.clone();
            }
        }
        if (sn == null) {
            sn = this.textualForm.toString();
            sd = denominator.textualForm.toString();
            ratio.element.mFirstOperand = (Expression.Element)this.element.clone();
            ratio.element.mSecondOperand = (Expression.Element)denominator.element.clone();
        }
        ratio.lastOp = BinaryOperatorRateNode.Operator.DIV;
        ratio.opIndex = sn.length();
        Expression.Element stab = BinaryOperatorRateNode.Operator.PLUS.getElement();
        stab.mFirstOperand = ratio.element.mSecondOperand;
        stab.mSecondOperand = BinaryOperatorRateNode.Operator.MINUS.getElement();
        stab.mSecondOperand.mFirstOperand = new Expression.Element(1.0);
        stab.mSecondOperand.mSecondOperand = new Expression.Element(Expression.ElementCode.THETA);
        stab.mSecondOperand.mSecondOperand.mFirstOperand = (Expression.Element)ratio.element.mFirstOperand.clone();
        ratio.element.mSecondOperand = stab;
        ratio.textualForm.append(sn).append((Object)BinaryOperatorRateNode.Operator.DIV).append("(");
        ratio.textualForm.append(sd).append("+1-theta(").append(sn).append("))");
        return ratio;
    }

    public Value returnAsValue() {
        if (!Double.isNaN(this.numerator)) {
            return new Value(this.numerator / this.denominator);
        }
        return new Value(new Expression(this.element));
    }

    public double toDouble() {
        if (Double.isNaN(this.numerator)) {
            throw new IllegalStateException("CompiledRate cannot simultaneously be an exact value and an expression.");
        }
        return this.numerator / this.denominator;
    }

    public CompiledRate clone() {
        CompiledRate c = new CompiledRate();
        if (this.textualForm != null) {
            c.textualForm = new StringBuilder(this.textualForm);
        }
        c.numerator = this.numerator;
        c.denominator = this.denominator;
        c.lastOp = this.lastOp;
        c.opIndex = this.opIndex;
        if (this.element != null) {
            c.element = (Expression.Element)this.element.clone();
        }
        return c;
    }

    public String toString() {
        if (this.textualForm != null) {
            return this.textualForm.toString();
        }
        return Double.toString(this.numerator / this.denominator);
    }

    private static class PassiveRateVisitor
    extends VEVisitor {
        int weight;

        private PassiveRateVisitor() {
        }

        public int getWeight(RateNode rate) {
            this.weight = 0;
            try {
                rate.accept(this);
            }
            catch (Exception exception) {
                this.weight = -1;
            }
            return this.weight;
        }

        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
            if (rate.getOperator() != BinaryOperatorRateNode.Operator.PLUS) {
                throw new IllegalStateException("Passive apparent rates in SBA models should only use addition.");
            }
            rate.getLeft().accept(this);
            rate.getRight().accept(this);
        }

        public void visitPassiveRateNode(PassiveRateNode passive) {
            this.weight += passive.getMultiplicity();
        }
    }

    private static class RatesVisitor
    extends VEVisitor {
        BinaryOperatorRateNode.Operator currentOp;
        Expression.Element element;
        StringBuilder textualForm;
        double lastRate;
        Map<String, RateNode> sbaRates;
        private String[] splitRate;

        private RatesVisitor() {
        }

        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
            rate.getRight().accept(this);
            BinaryOperatorRateNode.Operator rightOp = this.currentOp;
            double rightRate = this.lastRate;
            StringBuilder rightTextualForm = this.textualForm;
            Expression.Element rightElement = this.element;
            rate.getLeft().accept(this);
            BinaryOperatorRateNode.Operator leftOp = this.currentOp;
            double leftRate = this.lastRate;
            Expression.Element leftElement = this.element;
            this.currentOp = rate.getOperator();
            this.element = this.currentOp.getElement();
            this.element.mFirstOperand = leftElement;
            this.element.mSecondOperand = rightElement;
            if (!Double.isNaN(rightRate) && !Double.isNaN(leftRate)) {
                this.lastRate = this.currentOp.evaluate(leftRate, rightRate);
                this.element = new Expression.Element(this.lastRate);
                this.splitRate = Double.toString(this.lastRate).split("\\.");
                if (this.splitRate[1].length() <= 5 && this.textualForm == null && rightTextualForm == null) {
                    this.currentOp = null;
                    return;
                }
            } else {
                this.lastRate = Double.NaN;
            }
            if (this.textualForm == null) {
                this.textualForm = new StringBuilder().append(leftRate);
            }
            if (leftOp != null && (leftOp.precedence() < this.currentOp.precedence() || leftOp.equals((Object)BinaryOperatorRateNode.Operator.DIV))) {
                this.textualForm.insert(0, "(").append(")");
            }
            this.textualForm.append((Object)this.currentOp);
            if (rightTextualForm == null) {
                rightTextualForm = new StringBuilder().append(rightRate);
            }
            if (rightOp != null && (rightOp.precedence() <= this.currentOp.precedence() || rightOp.equals((Object)BinaryOperatorRateNode.Operator.DIV))) {
                rightTextualForm.insert(0, "(").append(")");
            }
            this.textualForm.append((CharSequence)rightTextualForm);
        }

        public void visitRateDoubleNode(RateDoubleNode doubleRate) {
            this.lastRate = doubleRate.getValue();
            this.element = new Expression.Element(this.lastRate);
            this.currentOp = null;
            this.textualForm = null;
        }

        public void visitVariableRateNode(VariableRateNode variableRate) {
            if (this.sbaRates != null) {
                RateNode rate = this.sbaRates.get(variableRate.getName());
                if (rate == null) {
                    super.visitVariableRateNode(variableRate);
                }
                rate.accept(this);
            } else {
                this.element = new Expression.Element(Expression.ElementCode.SYMBOL);
                this.element.mSymbol = new Symbol(variableRate.getName());
                this.currentOp = null;
                this.lastRate = Double.NaN;
            }
            this.textualForm = new StringBuilder(variableRate.getName());
        }

        /* synthetic */ RatesVisitor(RatesVisitor ratesVisitor, RatesVisitor ratesVisitor2) {
            this();
        }
    }

    private static class StringVisitor
    extends RatesVisitor {
        private StringVisitor() {
            super(null, null);
        }

        public void visitPassiveRateNode(PassiveRateNode passive) {
            this.currentOp = null;
            this.textualForm = new StringBuilder();
            int i = passive.getMultiplicity();
            if (i > 1) {
                this.textualForm.append(i).append("*");
                this.currentOp = BinaryOperatorRateNode.Operator.MULT;
            }
            this.textualForm.append("infty");
        }
    }
}

