/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.sba;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import uk.ac.ed.inf.pepa.parsing.ASTFactory;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.RateNode;
import uk.ac.ed.inf.pepa.sba.ReactionBuilderAction;
import uk.ac.ed.inf.pepa.sba.ReactionsSet;
import uk.ac.ed.inf.pepa.sba.SBAComponent;
import uk.ac.ed.inf.pepa.sba.SBAReaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReactionBuilder
implements Cloneable {
    String sourceDefinition;
    ReactionBuilder from = null;
    List<ReactionBuilderAction> moves = new LinkedList<ReactionBuilderAction>();

    ReactionBuilder() {
    }

    void addReaction(ReactionBuilder product, String action, RateNode rate) {
        ReactionBuilderAction rba = new ReactionBuilderAction();
        rba.setGoesTo(product);
        rba.setAction(action);
        rba.setRate(rate);
        this.moves.add(rba);
    }

    void addReaction(String constant, String action, RateNode rate) {
        ReactionBuilderAction rba = new ReactionBuilderAction();
        rba.setGoesTo(constant);
        if (action == null && rate == null) {
            rba.noPrefix();
        } else {
            rba.setAction(action);
            rba.setRate(rate);
        }
        this.moves.add(rba);
    }

    public ReactionBuilder clone() {
        ReactionBuilder clone = new ReactionBuilder();
        for (ReactionBuilderAction rba : this.moves) {
            clone.moves.add(rba.clone());
        }
        for (ReactionBuilderAction rba : clone.moves) {
            ReactionBuilder rb = rba.next;
            if (rb == null) continue;
            clone.link(rb);
        }
        clone.sourceDefinition = this.sourceDefinition;
        return clone;
    }

    ReactionsSet generateReactions() {
        return this.generateReactions(null);
    }

    ReactionsSet generateReactions(String constant) {
        ReactionsSet reactions = new ReactionsSet();
        for (ReactionBuilderAction rba : this.moves) {
            if (rba.noPrefix) continue;
            SBAReaction r = new SBAReaction();
            r.sourceDefinition = this.sourceDefinition;
            SBAComponent c = new SBAComponent(rba.product, rba.rate);
            r.addProduct(c);
            c = new SBAComponent(constant == null ? rba.getReactant() : constant, rba.rate);
            r.addReactant(c);
            r.setName(rba.action);
            if (reactions.reactions.contains(r)) {
                SBAReaction original = reactions.reactions.get(reactions.reactions.indexOf(r));
                BinaryOperatorRateNode addNode = ASTFactory.createBinaryOperationRate();
                addNode.setOperator(BinaryOperatorRateNode.Operator.PLUS);
                addNode.setLeft(original.reactants.getFirst().rate);
                addNode.setRight(c.rate);
                original.reactants.getFirst().setRate(addNode);
                continue;
            }
            reactions.reactions.add(r);
        }
        for (ReactionBuilderAction rba : this.moves) {
            if (rba.noPrefix) {
                reactions.reactionsToIterate.put(this.getName(), rba.product);
                continue;
            }
            ReactionBuilder rb = rba.next;
            if (rb != null) {
                ReactionsSet result = rb.generateReactions();
                reactions.reactions.addAll(result.reactions);
                reactions.reactionsToIterate.putAll(result.reactionsToIterate);
                continue;
            }
            reactions.reactionsToIterate.put(rba.product, null);
        }
        return reactions;
    }

    String getName() {
        StringBuilder s = new StringBuilder();
        if (this.moves.size() > 1) {
            s.append("(");
        }
        for (ReactionBuilderAction rba : this.moves) {
            s.append(rba.getReactant()).append(" + ");
        }
        s.delete(s.length() - 3, s.length());
        if (this.moves.size() > 1) {
            s.append(")");
        }
        return s.toString();
    }

    void hideActions(Set<String> hideSet) {
        for (ReactionBuilderAction rba : this.moves) {
            ReactionBuilder rb = rba.next;
            if (rb != null) {
                rb.hideActions(hideSet);
            }
            if (rba.action == null || !hideSet.contains(rba.action)) continue;
            rba.setAction("tau");
        }
    }

    void link(ReactionBuilder previousFrontState) {
        previousFrontState.from = this;
    }

    ReactionBuilder merge(ReactionBuilder secondReaction) throws IllegalStateException {
        if (this.from != null || secondReaction.from != null) {
            throw new IllegalStateException("One or both of the reactions selected to be merged is not the head of a sequence. Cannot merge.");
        }
        ReactionBuilder mergedReaction = new ReactionBuilder();
        mergedReaction.moves.addAll(this.moves);
        mergedReaction.moves.addAll(secondReaction.moves);
        ReactionBuilder rb = null;
        for (ReactionBuilderAction rba : mergedReaction.moves) {
            rb = rba.next;
        }
        if (rb != null) {
            mergedReaction.link(rb);
        }
        return mergedReaction;
    }

    void setSource(String name) {
        this.sourceDefinition = name;
        for (ReactionBuilderAction rba : this.moves) {
            if (rba.next == null) continue;
            rba.next.setSource(name);
        }
    }
}

