/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.sba;

import uk.ac.ed.inf.pepa.parsing.ASTSupport;
import uk.ac.ed.inf.pepa.parsing.RateNode;
import uk.ac.ed.inf.pepa.sba.CompiledRate;
import uk.ac.ed.inf.pepa.sba.ReactionBuilder;

class ReactionBuilderAction
implements Cloneable {
    String action = null;
    String product = null;
    ReactionBuilder next = null;
    boolean noPrefix = false;
    RateNode rate = null;
    StringBuilder reactant = new StringBuilder();

    ReactionBuilderAction() {
    }

    public ReactionBuilderAction clone() {
        ReactionBuilderAction clone = new ReactionBuilderAction();
        clone.reactant = new StringBuilder(this.reactant.toString());
        clone.action = this.action;
        clone.product = this.product;
        clone.noPrefix = this.noPrefix;
        clone.rate = (RateNode)ASTSupport.copy(this.rate);
        if (this.next != null) {
            clone.next = this.next.clone();
        }
        return clone;
    }

    String getReactant() {
        if (this.reactant.length() != 0) {
            return this.reactant.toString();
        }
        return null;
    }

    void noPrefix() {
        this.rate = null;
        this.action = null;
        this.noPrefix = true;
        if (this.product != null) {
            this.update();
        }
    }

    void setAction(String action) {
        this.action = action;
        if (this.product != null && action != null && this.rate != null) {
            this.update();
        }
    }

    void setGoesTo(ReactionBuilder next) {
        this.next = next;
        this.product = this.next.getName();
        if (this.product != null && this.action != null && this.rate != null) {
            this.update();
        }
    }

    void setGoesTo(String constant) {
        this.product = constant;
        this.next = null;
        if (this.product != null && this.action != null && this.rate != null) {
            this.update();
        }
    }

    void setRate(RateNode rate) {
        this.rate = rate;
        if (this.product != null && this.action != null && rate != null) {
            this.update();
        }
    }

    private void update() {
        this.reactant.setLength(0);
        if (this.noPrefix) {
            this.reactant.append(this.product);
        } else {
            this.reactant.append("(").append(this.action).append(",");
            this.reactant.append(CompiledRate.toString(this.rate));
            this.reactant.append(").").append(this.product);
        }
    }
}

