/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.sba;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.analysis.internal.ProblemFactory;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.Compiler;
import uk.ac.ed.inf.pepa.model.Model;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.ExpressionVisitor;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.MoveOnVisitor;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;
import uk.ac.ed.inf.pepa.sba.Mapping;
import uk.ac.ed.inf.pepa.sba.SBAComponent;
import uk.ac.ed.inf.pepa.sba.SBAInterface;
import uk.ac.ed.inf.pepa.sba.SBAReaction;
import uk.ac.ed.inf.pepa.sba.SBASupport;
import uk.ac.ed.inf.pepa.sba.SBAVisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReagentCentricPEPAtoSBA
implements SBAInterface {
    Mapping map = null;
    ModelNode originalModel;
    Map<String, Number> sbaPopulations = null;
    Map<String, RateNode> sbaRates = null;
    Set<SBAReaction> sbaReactions = null;

    public ReagentCentricPEPAtoSBA(ModelNode model) {
        if (model == null) {
            throw new NullPointerException("Null ModelNode passed.");
        }
        this.originalModel = model;
    }

    @Override
    public synchronized Mapping getMapping() {
        return this.map;
    }

    @Override
    public synchronized Map<String, Number> getPopulations() {
        return this.sbaPopulations;
    }

    @Override
    public synchronized Map<String, RateNode> getRates() {
        return this.sbaRates;
    }

    @Override
    public synchronized Set<SBAReaction> getReactions() {
        HashSet<SBAReaction> copy = new HashSet<SBAReaction>();
        for (SBAReaction r : this.sbaReactions) {
            copy.add(r.clone());
        }
        return copy;
    }

    @Override
    public boolean isParseable() {
        this.sbaRates = new HashMap<String, RateNode>();
        this.sbaReactions = new HashSet<SBAReaction>();
        HashSet<String> allPostfixes = new HashSet<String>();
        HashSet<String> highPostfixes = new HashSet<String>();
        allPostfixes.add("_H");
        allPostfixes.add("_L");
        highPostfixes.add("_H");
        ParseProcessesVisitor parseCheckVisitor = new ParseProcessesVisitor(allPostfixes, highPostfixes);
        this.originalModel.accept(parseCheckVisitor);
        return parseCheckVisitor.rcProblems.size() == 0;
    }

    public synchronized void parseModel() {
        this.sbaRates = new HashMap<String, RateNode>();
        this.sbaReactions = new HashSet<SBAReaction>();
        this.sbaPopulations = new HashMap<String, Number>();
        HashSet<String> allPostfixes = new HashSet<String>();
        HashSet<String> highPostfixes = new HashSet<String>();
        allPostfixes.add("_H");
        allPostfixes.add("_L");
        highPostfixes.add("_H");
        ParseProcessesVisitor preParseVisitor = new ParseProcessesVisitor(allPostfixes, highPostfixes);
        this.originalModel.accept(preParseVisitor);
        ParseSystemEquationVisitor parseVisitor = new ParseSystemEquationVisitor(preParseVisitor.reactionMap, highPostfixes, this.originalModel);
        this.originalModel.accept(parseVisitor);
        this.map = new Mapping();
        this.map.originalRepresentation = "Species";
        for (String s : this.sbaPopulations.keySet()) {
            this.map.labelled.put(s, s);
        }
    }

    @Override
    public synchronized void updateReactions(Set<SBAReaction> updatedReactions) {
        for (SBAReaction reaction : this.sbaReactions) {
            boolean found = false;
            for (SBAReaction r : updatedReactions) {
                if (!reaction.equals(r)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Reaction sets do not match.");
        }
        if (this.sbaReactions.size() != updatedReactions.size()) {
            throw new IllegalArgumentException("Reaction sets do not match.");
        }
        HashSet<SBAReaction> tSet = new HashSet<SBAReaction>(this.sbaReactions);
        SBAReaction tReaction = null;
        for (SBAReaction newReaction : updatedReactions) {
            for (SBAReaction reaction : tSet) {
                if (!reaction.equals(newReaction)) continue;
                tReaction = reaction;
                break;
            }
            tSet.remove(tReaction);
            List<SBAComponent> components = tReaction.getReactants();
            block4: for (SBAComponent updatedComponent : newReaction.getReactants()) {
                for (SBAComponent component : components) {
                    if (!updatedComponent.equals(component)) continue;
                    component.setStoichiometry(updatedComponent.getStoichiometry());
                    continue block4;
                }
            }
            components = tReaction.getProducts();
            block6: for (SBAComponent updatedComponent : newReaction.getProducts()) {
                for (SBAComponent component : components) {
                    if (!updatedComponent.equals(component)) continue;
                    component.setStoichiometry(updatedComponent.getStoichiometry());
                    continue block6;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParseProcessesVisitor
    extends MoveOnVisitor {
        private Set<String> highPostfixes;
        private Set<String> acceptablePostfixes;
        private boolean leftHigh;
        private boolean rightHigh;
        private String leftName;
        private String rightName;
        private String actionName;
        List<IProblem> rcProblems;
        Map<String, Set<SBAReaction>> reactionMap;
        private SBAComponent sbaComponent;
        private SBAReaction sbaReaction;
        private Map<String, RateNode> tSBARates;

        ParseProcessesVisitor(Set<String> allPostfixes, Set<String> highPostfixes) {
            if (allPostfixes == null || allPostfixes.size() == 0) {
                throw new IllegalArgumentException("Reagent-centric postfixes cannot be null or empty.");
            }
            if (highPostfixes == null || highPostfixes.size() == 0) {
                throw new IllegalArgumentException("Reagent-centric postfixes representing high states cannot be null or empty.");
            }
            this.acceptablePostfixes = allPostfixes;
            this.highPostfixes = highPostfixes;
            this.tSBARates = new HashMap<String, RateNode>();
            this.rcProblems = new LinkedList<IProblem>();
            this.reactionMap = new HashMap<String, Set<SBAReaction>>();
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            this.rightName = constant.getName();
            boolean valid = false;
            for (String postfix : this.acceptablePostfixes) {
                if (!this.rightName.endsWith(postfix) || !this.rightName.equals(String.valueOf(this.leftName) + postfix)) continue;
                valid = true;
                this.rightHigh = this.highPostfixes.contains(postfix);
                break;
            }
            if (!valid) {
                this.rcProblems.add(ProblemFactory.buildProblem(1310727, constant, "Constant does not end with valid reagent-centrix postfix."));
            }
        }

        @Override
        public void visitCooperationNode(CooperationNode cooperation) {
            this.reactionMap.remove(this.leftName);
        }

        @Override
        public void visitHidingNode(HidingNode hiding) {
            this.rcProblems.add(ProblemFactory.buildProblem(0x10000E, hiding, "The hiding operator is not currently permissible within the reagent-centric approach."));
        }

        @Override
        public void visitModelNode(ModelNode model) {
            for (RateDefinitionNode rdn : model.rateDefinitions()) {
                this.tSBARates.put(rdn.getName().getName(), rdn.getRate());
            }
            for (ProcessDefinitionNode pdn : model.processDefinitions()) {
                pdn.accept(this);
            }
        }

        @Override
        public void visitPrefixNode(PrefixNode prefix) {
            if (!(prefix.getTarget() instanceof ConstantProcessNode)) {
                this.rcProblems.add(ProblemFactory.buildProblem(0x10000E, prefix, "The sequential component to the prefix is not a constant."));
                return;
            }
            if (!(prefix.getActivity().getAction() instanceof ActionTypeNode)) {
                this.rcProblems.add(ProblemFactory.buildProblem(0x110001, prefix, "All actions must be defined with the reagent-centric approach."));
                return;
            }
            prefix.getTarget().accept(this);
            prefix.getActivity().getRate().accept(this);
            this.sbaComponent = new SBAComponent(this.leftName, prefix.getActivity().getRate());
            this.sbaReaction = new SBAReaction(((ActionTypeNode)prefix.getActivity().getAction()).getType());
            if (this.leftHigh) {
                if (this.rightHigh) {
                    this.sbaComponent.makeCatalyst();
                }
                this.sbaReaction.addReactant(this.sbaComponent);
            } else if (this.rightHigh) {
                this.sbaReaction.addProduct(this.sbaComponent);
            } else {
                this.sbaComponent.makeInhibitor();
                this.sbaReaction.addReactant(this.sbaComponent);
            }
            this.reactionMap.get(this.leftName).add(this.sbaReaction);
        }

        @Override
        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            String processDefName = processDefinition.getName().getName();
            boolean valid = false;
            for (String postfix : this.acceptablePostfixes) {
                if (!processDefName.endsWith(postfix)) continue;
                this.leftName = processDefName.substring(0, processDefName.length() - postfix.length());
                if (!this.reactionMap.containsKey(this.leftName)) {
                    this.reactionMap.put(this.leftName, new HashSet());
                }
                valid = true;
                this.leftHigh = this.highPostfixes.contains(postfix);
                processDefinition.getNode().accept(this);
                break;
            }
            if (!valid) {
                this.rcProblems.add(ProblemFactory.buildProblem(1310727, processDefinition.getName(), "Constant does not end with valid reagent-centrix postfix."));
            }
        }

        @Override
        public void visitVariableRateNode(VariableRateNode variableRate) {
            this.actionName = variableRate.getName();
            if (this.tSBARates.containsKey(this.actionName)) {
                ReagentCentricPEPAtoSBA.this.sbaRates.put(this.actionName, this.tSBARates.remove(this.actionName));
            }
        }

        @Override
        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            this.reactionMap.remove(this.leftName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParseSystemEquationVisitor
    extends MoveOnVisitor {
        Set<SBAReaction> currentReactions;
        private Set<String> highPostfixes;
        String lastConstant;
        Map<String, Set<SBAReaction>> reactionMap;
        private Model compiledModel;

        ParseSystemEquationVisitor(Map<String, Set<SBAReaction>> reactionMap, Set<String> highPostfixes, ModelNode node) {
            this.compiledModel = new Compiler(node).getModel();
            this.reactionMap = reactionMap;
            this.highPostfixes = highPostfixes;
        }

        @Override
        public void visitAggregationNode(AggregationNode aggregation) {
            aggregation.getProcessNode().accept(this);
            if (ReagentCentricPEPAtoSBA.this.sbaPopulations.get(this.lastConstant).intValue() == 0) {
                throw new SBAVisitorException(Thread.currentThread().getStackTrace());
            }
            ExpressionVisitor v = new ExpressionVisitor(this.compiledModel);
            aggregation.getCopies().accept(v);
            ReagentCentricPEPAtoSBA.this.sbaPopulations.put(this.lastConstant, new Integer(v.eval()));
        }

        @Override
        public void visitConstantProcessNode(ConstantProcessNode constant) {
            this.lastConstant = constant.getName();
            while (!this.reactionMap.keySet().contains(this.lastConstant)) {
                this.lastConstant = this.lastConstant.substring(0, this.lastConstant.length() - 1);
            }
            ReagentCentricPEPAtoSBA.this.sbaPopulations.put(this.lastConstant, new Integer(0));
            for (String s : this.highPostfixes) {
                if (!constant.getName().equals(String.valueOf(this.lastConstant) + s)) continue;
                ReagentCentricPEPAtoSBA.this.sbaPopulations.put(this.lastConstant, new Integer(1));
                break;
            }
            this.currentReactions = this.reactionMap.remove(this.lastConstant);
            if (this.currentReactions == null) {
                throw new SBAVisitorException(Thread.currentThread().getStackTrace());
            }
        }

        @Override
        public void visitCooperationNode(CooperationNode cooperation) {
            cooperation.getLeft().accept(this);
            Set<SBAReaction> left = this.currentReactions;
            cooperation.getRight().accept(this);
            Set<SBAReaction> right = this.currentReactions;
            this.currentReactions = new HashSet<SBAReaction>();
            HashSet<String> coopSet = new HashSet<String>();
            for (ActionTypeNode atn : cooperation.getActionSet()) {
                coopSet.add(atn.getType());
            }
            for (SBAReaction l : left) {
                if (coopSet.contains(l.getName())) {
                    for (SBAReaction r : right) {
                        if (!r.getName().equals(l.getName())) continue;
                        this.currentReactions.add(l.merge(r));
                    }
                    continue;
                }
                this.currentReactions.add(l);
            }
            for (SBAReaction r : right) {
                if (coopSet.contains(r.getName())) continue;
                this.currentReactions.add(r);
            }
        }

        @Override
        public void visitHidingNode(HidingNode hiding) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitModelNode(ModelNode model) {
            SBASupport.expandSystemEquation(model).accept(this);
            ReagentCentricPEPAtoSBA.this.sbaReactions = this.currentReactions;
        }

        @Override
        public void visitPrefixNode(PrefixNode prefix) {
            throw new SBAVisitorException(Thread.currentThread().getStackTrace());
        }

        @Override
        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            cooperation.getLeft().accept(this);
            Set<SBAReaction> left = this.currentReactions;
            cooperation.getRight().accept(this);
            Set<SBAReaction> right = this.currentReactions;
            this.currentReactions = new HashSet<SBAReaction>();
            HashSet<String> used = new HashSet<String>();
            for (SBAReaction l : left) {
                boolean unused = true;
                String name = l.getName();
                used.add(name);
                for (SBAReaction r : right) {
                    if (!r.getName().equals(name)) continue;
                    this.currentReactions.add(l.merge(r));
                    unused = false;
                }
                if (!unused) continue;
                this.currentReactions.add(l);
            }
            for (SBAReaction r : right) {
                if (used.contains(r.getName())) continue;
                this.currentReactions.add(r);
            }
        }
    }
}

