/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.sba;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.chem.Compartment;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.ModelBuilderCommandLanguage;
import org.systemsbiology.chem.Parameter;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.ReservedSymbolMapperChemCommandLanguage;
import org.systemsbiology.chem.SimulationController;
import org.systemsbiology.chem.SimulationProgressReporter;
import org.systemsbiology.chem.SimulationResults;
import org.systemsbiology.chem.Simulator;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.SimulatorStochasticGibsonBruck;
import org.systemsbiology.chem.SimulatorStochasticGillespie;
import org.systemsbiology.chem.Species;
import org.systemsbiology.chem.odetojava.SimulatorOdeToJavaRungeKuttaAdaptive;
import org.systemsbiology.chem.odetojava.SimulatorOdeToJavaRungeKuttaImplicit;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.ReservedSymbolMapper;
import org.systemsbiology.util.IncludeHandler;
import org.systemsbiology.util.InvalidInputException;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.RateNode;
import uk.ac.ed.inf.pepa.sba.CompiledRate;
import uk.ac.ed.inf.pepa.sba.Mapping;
import uk.ac.ed.inf.pepa.sba.Results;
import uk.ac.ed.inf.pepa.sba.SBAComponent;
import uk.ac.ed.inf.pepa.sba.SBAInterface;
import uk.ac.ed.inf.pepa.sba.SBAReaction;
import uk.ac.ed.inf.pepa.sba.SBASimulatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBAtoISBJava {
    private static String term = System.getProperty("line.separator");
    Algorithm algorithm;
    boolean apparentRate = true;
    boolean cmdl = false;
    Mapping map;
    Model model = null;
    int numberOfSamples = 3;
    Map<String, Number> sbaPopulations;
    Map<String, RateNode> sbaRates;
    Set<SBAReaction> sbaReactions;
    SimulationResults simulationResults = null;
    Simulator simulator = null;
    SimulationController simulatorController;
    SimulatorParameters simulatorParameters = null;
    SimulationProgressReporter simulatorProgress = new SimulationProgressReporter();
    double startTime = 0.0;
    double stopTime = 0.0;
    String[] trackedSpecies = null;
    Set<String> zeroedSpecies = null;

    public static SBAtoISBJava generateModel(String cmdlModel) {
        SBAtoISBJava newModel = new SBAtoISBJava();
        ModelBuilderCommandLanguage mb = new ModelBuilderCommandLanguage();
        try {
            newModel.model = mb.buildModel((InputStream)new ByteArrayInputStream(cmdlModel.getBytes()), new IncludeHandler());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error parsing cmdl model. " + e.getMessage());
        }
        catch (InvalidInputException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        newModel.cmdl = true;
        newModel.map = new Mapping();
        newModel.map.originalRepresentation = "Species";
        String[] stringArray = newModel.model.getOrderedSpeciesNamesArray();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            newModel.map.labelled.put(s, s);
            ++n2;
        }
        return newModel;
    }

    private SBAtoISBJava() {
        this.simulatorController = new SimulationController();
    }

    public SBAtoISBJava(SBAInterface pepaModel) {
        this();
        this.sbaRates = pepaModel.getRates();
        this.sbaReactions = pepaModel.getReactions();
        this.map = pepaModel.getMapping();
        HashSet<String> tHashSet = new HashSet<String>();
        for (SBAReaction r : this.sbaReactions) {
            tHashSet.add(r.name);
        }
        if (tHashSet.size() < this.sbaReactions.size()) {
            throw new IllegalArgumentException("Reactions names must be unique.");
        }
        this.sbaPopulations = pepaModel.getPopulations();
    }

    public void cancelSimulation() {
        this.simulatorController.setCancelled(true);
    }

    public synchronized void generateISBJavaModel(String modelName, boolean apparentRate) {
        CompiledRate rate;
        Species tSpecies;
        if (this.cmdl) {
            throw new IllegalStateException("Cannot generate model when loading from cmdl file.");
        }
        this.apparentRate = apparentRate;
        this.model = new Model(modelName);
        Compartment compartment = new Compartment("main");
        this.zeroedSpecies = new HashSet<String>();
        this.model.setReservedSymbolMapper((ReservedSymbolMapper)new ReservedSymbolMapperChemCommandLanguage());
        HashSet<String> usedIDs = new HashSet<String>();
        HashMap<String, Species> speciesMap = new HashMap<String, Species>();
        for (Map.Entry<String, Number> me : this.sbaPopulations.entrySet()) {
            tSpecies = new Species(me.getKey(), compartment);
            tSpecies.setSpeciesPopulation(me.getValue().doubleValue());
            speciesMap.put(me.getKey(), tSpecies);
            usedIDs.add(me.getKey());
        }
        for (Map.Entry<String, RateNode> e : this.sbaRates.entrySet()) {
            rate = CompiledRate.compileRate(e.getValue(), null);
            if (rate.isExpression()) {
                this.model.addParameter(new Parameter(e.getKey(), new Expression(rate.toString())));
            } else {
                this.model.addParameter(new Parameter(e.getKey(), rate.toDouble()));
            }
            usedIDs.add(e.getKey());
        }
        for (SBAReaction reaction : this.sbaReactions) {
            Reaction tReaction = new Reaction(reaction.name);
            for (SBAComponent component : reaction.reactants) {
                tSpecies = (Species)speciesMap.get(component.name);
                if (tSpecies == null) {
                    tSpecies = new Species(component.name, compartment);
                    tSpecies.setSpeciesPopulation(0.0);
                    speciesMap.put(component.name, tSpecies);
                    this.zeroedSpecies.add(component.name);
                }
                tReaction.addReactant(tSpecies, component.stoichiometry, !component.catalyst && !component.inhibitor);
            }
            for (SBAComponent component : reaction.products) {
                tSpecies = (Species)speciesMap.get(component.name);
                if (tSpecies == null) {
                    tSpecies = new Species(component.name, compartment);
                    tSpecies.setSpeciesPopulation(0.0);
                    speciesMap.put(component.name, tSpecies);
                    this.zeroedSpecies.add(component.name);
                }
                tReaction.addProduct(tSpecies, component.stoichiometry);
            }
            rate = apparentRate ? this.getApparentRate(reaction) : this.getMassActionRate(reaction);
            tReaction.setRate(rate.returnAsValue());
            this.model.addReaction(tReaction);
        }
        System.err.println(this.model.toString());
    }

    private CompiledRate getApparentRate(SBAReaction reaction) {
        return reaction.overall;
    }

    public Mapping getMapping() {
        return this.map;
    }

    private CompiledRate getMassActionRate(SBAReaction reaction) {
        CompiledRate nextRate;
        LinkedList<SBAComponent> reactants = new LinkedList<SBAComponent>();
        LinkedList<SBAComponent> catalysts = new LinkedList<SBAComponent>();
        LinkedList<SBAComponent> inhibitors = new LinkedList<SBAComponent>();
        if (reaction.reactants.size() == 0 && reaction.products.size() == 1) {
            return CompiledRate.compileRate(reaction.products.getFirst().rate, null);
        }
        for (SBAComponent c : reaction.reactants) {
            if (c.isCatalyst()) {
                catalysts.add(c);
                continue;
            }
            if (c.isInhibitor()) {
                inhibitors.add(c);
                continue;
            }
            reactants.add(c);
        }
        CompiledRate rate = null;
        for (SBAComponent c : reactants) {
            if (CompiledRate.isPassive(c)) continue;
            nextRate = CompiledRate.compileRate(c.rate, null);
            if (rate == null) {
                rate = nextRate;
                continue;
            }
            if (rate.equals(nextRate)) continue;
            throw new IllegalStateException("Non-equal rates in reaction " + reaction.getName() + ".");
        }
        for (SBAComponent c : catalysts) {
            if (CompiledRate.isPassive(c)) continue;
            nextRate = CompiledRate.compileRate(c.rate, null);
            if (rate == null) {
                rate = nextRate;
                continue;
            }
            if (rate.equals(nextRate)) continue;
            throw new IllegalStateException("Non-equal rates in reaction " + reaction.getName() + ".");
        }
        if (rate == null) {
            throw new IllegalStateException("Undefined rate for reaction " + reaction.getName() + ".");
        }
        if (inhibitors.size() == 0 && !rate.isExpression()) {
            return rate;
        }
        for (SBAComponent c : reactants) {
            nextRate = new CompiledRate(c);
            if (c.getStoichiometry() > 1) {
                nextRate = CompiledRate.pow(nextRate, c.getStoichiometry());
            }
            rate = rate.op(BinaryOperatorRateNode.Operator.MULT, nextRate);
        }
        for (SBAComponent c : catalysts) {
            nextRate = new CompiledRate(c);
            if (c.getStoichiometry() > 1) {
                nextRate = CompiledRate.pow(nextRate, c.getStoichiometry());
            }
            rate = rate.op(BinaryOperatorRateNode.Operator.MULT, nextRate);
        }
        for (SBAComponent c : inhibitors) {
            nextRate = new CompiledRate(c);
            if (c.getStoichiometry() > 1) {
                nextRate = CompiledRate.pow(nextRate, c.getStoichiometry());
            }
            nextRate = nextRate.op(BinaryOperatorRateNode.Operator.DIV, CompiledRate.compileRate(c.rate, null));
            nextRate = new CompiledRate(1).op(BinaryOperatorRateNode.Operator.PLUS, nextRate);
            nextRate = new CompiledRate(1).op(BinaryOperatorRateNode.Operator.DIV, nextRate);
            rate = rate.op(BinaryOperatorRateNode.Operator.MULT, nextRate);
        }
        return rate;
    }

    public OptionsMap.Solver[] getPermissibleSolvers() {
        OptionsMap.Solver[] solvers = OptionsMap.Solver.values();
        ArrayList<OptionsMap.Solver> pSolvers = new ArrayList<OptionsMap.Solver>();
        OptionsMap.Solver[] solverArray = solvers;
        int n = solvers.length;
        int n2 = 0;
        while (n2 < n) {
            OptionsMap.Solver solver = solverArray[n2];
            if (solver.getType().equals((Object)OptionsMap.SolverType.ODE) || solver.getType().equals((Object)OptionsMap.SolverType.Stochastic)) {
                pSolvers.add(solver);
            }
            ++n2;
        }
        return pSolvers.toArray(new OptionsMap.Solver[0]);
    }

    public synchronized void initialiseSimulator(OptionsMap options) throws SBASimulatorException {
        if (this.model == null) {
            throw new IllegalStateException("ISBJava model not generated.");
        }
        this.algorithm = Algorithm.getAlgorithm((OptionsMap.Solver)((Object)options.getValue(OptionsMap.Parameter.Solver)));
        if (this.algorithm == null) {
            throw new IllegalArgumentException(String.valueOf(((OptionsMap.Solver)((Object)options.getValue(OptionsMap.Parameter.Solver))).getDescriptiveName()) + " is not an acceptable solver.");
        }
        this.simulator = this.algorithm.getSimulator();
        this.simulatorParameters = this.algorithm.getSimulatorParameters(this.simulator);
        this.algorithm.initializeSimulator(this.simulator, this.model);
        this.simulator.setProgressReporter(this.simulatorProgress);
        this.simulator.setController(this.simulatorController);
        this.startTime = (Double)options.getValue(OptionsMap.Parameter.Start_Time);
        this.stopTime = (Double)options.getValue(OptionsMap.Parameter.Stop_Time);
        if (this.startTime < 0.0 || this.startTime >= this.stopTime) {
            throw new IllegalArgumentException("Start time < 0.00 || start time >= stop time.");
        }
        double tDouble = (Double)options.getValue(OptionsMap.Parameter.Step_Size);
        if (tDouble <= 0.0) {
            throw new IllegalArgumentException(String.valueOf(OptionsMap.Parameter.Step_Size.toString()) + " (=" + tDouble + ") must be greater than 0.00.");
        }
        this.simulatorParameters.setStepSizeFraction(tDouble);
        int tInt = (Integer)options.getValue(OptionsMap.Parameter.Independent_Replications);
        if (tInt < 1) {
            throw new IllegalArgumentException("#Replications must be greater than 0.");
        }
        this.simulatorParameters.setEnsembleSize(tInt);
        tDouble = (Double)options.getValue(OptionsMap.Parameter.Confidence_Interval);
        if (tDouble <= 0.0 || tDouble >= 1.0) {
            throw new IllegalArgumentException("Confidence interval must be a value between 0.00 and 1.00 (exclusive)");
        }
        this.simulatorParameters.setConfidenceInterval(tDouble);
        tInt = (Integer)options.getValue(OptionsMap.Parameter.Data_Points);
        if (tInt < 3) {
            throw new IllegalArgumentException("#Data points must be greater than 2.");
        }
        this.numberOfSamples = tInt;
        tDouble = (Double)options.getValue(OptionsMap.Parameter.Relative_Error);
        if (tDouble <= 0.0) {
            throw new IllegalArgumentException(String.valueOf(OptionsMap.Parameter.Relative_Error.toString()) + " (=" + tDouble + ") must be greater than 0.00.");
        }
        this.simulatorParameters.setMaxAllowedRelativeError(tDouble);
        tDouble = (Double)options.getValue(OptionsMap.Parameter.Absolute_Error);
        if (tDouble <= 0.0) {
            throw new IllegalArgumentException(String.valueOf(OptionsMap.Parameter.Absolute_Error.toString()) + " (=" + tDouble + ") must be greater than 0.00.");
        }
        this.simulatorParameters.setMaxAllowedAbsoluteError(tDouble);
        this.trackedSpecies = (String[])options.getValue(OptionsMap.Parameter.Components);
        if (this.trackedSpecies.length == 0) {
            throw new IllegalArgumentException(String.valueOf(OptionsMap.Parameter.Components.toString()) + " must contain at least one component.");
        }
        HashSet<String> knownSpecies = new HashSet<String>(Arrays.asList(this.model.getOrderedSpeciesNamesArray()));
        String[] stringArray = this.trackedSpecies;
        int n = this.trackedSpecies.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            if (!knownSpecies.contains(component)) {
                this.trackedSpecies = null;
                throw new IllegalArgumentException(String.valueOf(OptionsMap.Parameter.Components.toString()) + ": " + component + " is not a valid selection.");
            }
            ++n2;
        }
    }

    public boolean isFinished() {
        return this.simulatorProgress.getSimulationFinished();
    }

    public int percentageComplete() {
        return (int)(this.simulatorProgress.getFractionComplete() * 100.0);
    }

    public synchronized Results runModel() throws SBASimulatorException {
        return this.runModel(null);
    }

    public synchronized Results runModel(final IProgressMonitor monitor) throws SBASimulatorException {
        if (this.stopTime <= this.startTime) {
            throw new IllegalStateException("Stop time must be greater than start time.");
        }
        this.simulatorProgress.setSimulationFinished(false);
        Thread monitorController = null;
        if (monitor != null) {
            monitorController = new Thread(){

                public void run() {
                    try {
                        int SCALING_UNIT = 100;
                        int previous = 0;
                        int current = 0;
                        monitor.beginTask(SCALING_UNIT);
                        while (!SBAtoISBJava.this.simulatorProgress.getSimulationFinished()) {
                            if (monitor.isCanceled()) {
                                SBAtoISBJava.this.simulatorController.setCancelled(true);
                            }
                            SBAtoISBJava.this.simulatorProgress.waitForUpdate();
                            current = (int)(SBAtoISBJava.this.simulatorProgress.getFractionComplete() * 100.0);
                            monitor.worked(current - previous);
                            previous = current;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            monitorController.start();
        }
        try {
            this.simulationResults = this.algorithm.simulate(this.simulator, this.startTime, this.stopTime, this.simulatorParameters, this.numberOfSamples, this.trackedSpecies);
        }
        catch (SBASimulatorException e) {
            if (monitorController != null) {
                monitorController.interrupt();
            }
            throw e;
        }
        return new Results(this.simulationResults);
    }

    public void waitForUpdate() {
        this.simulatorProgress.waitForUpdate();
    }

    public String writeCMDL() {
        if (this.cmdl) {
            throw new IllegalStateException("Cannot write cmdl file when model generated from cmdl file.");
        }
        if (this.model == null) {
            throw new NullPointerException("Must generate ISBJava model to write CMDL file.");
        }
        StringBuilder cmdl = new StringBuilder();
        cmdl.append("//Rates").append(term);
        Object[] sA = new String[this.sbaRates.size()];
        this.sbaRates.keySet().toArray(sA);
        Arrays.sort(sA);
        Object[] objectArray = sA;
        int n = sA.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            cmdl.append((String)name).append(" = ");
            cmdl.append(CompiledRate.toString(this.sbaRates.get(name)));
            cmdl.append(";").append(term);
            ++n2;
        }
        HashMap<String, String> completeNameMapping = new HashMap<String, String>();
        Mapping tMapping = this.map;
        while (tMapping.previous != null) {
            tMapping = tMapping.previous;
        }
        while (tMapping != null) {
            completeNameMapping.putAll(tMapping.labelled);
            completeNameMapping.putAll(tMapping.unlabelled);
            tMapping = tMapping.next;
        }
        cmdl.append(term).append("//Population sizes").append(term);
        sA = new String[this.sbaPopulations.size()];
        this.sbaPopulations.keySet().toArray(sA);
        Arrays.sort(sA);
        Object[] objectArray2 = sA;
        int n3 = sA.length;
        int n4 = 0;
        while (n4 < n3) {
            Object name = objectArray2[n4];
            cmdl.append((String)name).append(" = ");
            cmdl.append(this.sbaPopulations.get(name)).append("; // ");
            cmdl.append((String)completeNameMapping.get(name)).append(term);
            ++n4;
        }
        cmdl.append(term).append("//Reactions").append(term);
        HashMap<String, SBAReaction> tHashMap = new HashMap<String, SBAReaction>();
        for (SBAReaction sbaReaction : this.sbaReactions) {
            tHashMap.put(sbaReaction.name, sbaReaction);
        }
        sA = new String[tHashMap.size()];
        tHashMap.keySet().toArray(sA);
        Arrays.sort(sA);
        Object[] objectArray3 = sA;
        int n5 = sA.length;
        int n6 = 0;
        while (n6 < n5) {
            CompiledRate rate;
            Object name = objectArray3[n6];
            SBAReaction tSBAReaction = (SBAReaction)tHashMap.get(name);
            cmdl.append(tSBAReaction.toCMDL()).append(", ");
            CompiledRate compiledRate = rate = this.apparentRate ? this.getApparentRate(tSBAReaction) : this.getMassActionRate(tSBAReaction);
            if (rate.isExpression()) {
                cmdl.append("[").append(rate.toString()).append("]");
            } else {
                cmdl.append(rate.toString());
            }
            cmdl.append(";").append(term);
            ++n6;
        }
        return cmdl.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String writeMatlab() {
        void var9_31;
        void var9_29;
        void var9_26;
        void var9_24;
        String s;
        String functionName = "PEPA_model_ODEs";
        StringBuilder m = new StringBuilder();
        StringBuilder clearList = new StringBuilder();
        HashMap<String, String> mMap = new HashMap<String, String>();
        HashMap<String, Integer> cMap = new HashMap<String, Integer>();
        HashSet<String> set = new HashSet<String>();
        m.append("% Rates").append(term);
        Object[] sA = new String[this.sbaRates.size()];
        this.sbaRates.keySet().toArray(sA);
        Arrays.sort(sA);
        Object[] objectArray = sA;
        int n = sA.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            s = SBAtoISBJava.matlabName((String)object);
            if (cMap.containsKey(s)) {
                cMap.put(s, (Integer)cMap.get(s) + 1);
                set.remove(s);
            } else {
                cMap.put(s, 1);
                set.add(s);
            }
            mMap.put((String)object, s);
            ++n2;
        }
        sA = new String[this.sbaPopulations.size()];
        this.sbaPopulations.keySet().toArray(sA);
        Arrays.sort(sA);
        objectArray = sA;
        n = sA.length;
        n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (this.sbaPopulations.get(object).doubleValue() != 0.0) {
                s = SBAtoISBJava.matlabName((String)object);
                if (cMap.containsKey(s)) {
                    cMap.put(s, (Integer)cMap.get(s) + 1);
                    set.remove(s);
                } else {
                    cMap.put(s, 1);
                    set.add(s);
                }
                mMap.put((String)object, s);
            }
            ++n2;
        }
        for (String string : set) {
            cMap.remove(string);
        }
        for (String string : cMap.keySet()) {
            cMap.put(string, 1);
        }
        sA = new String[this.sbaRates.size()];
        this.sbaRates.keySet().toArray(sA);
        Arrays.sort(sA);
        clearList.append("clear");
        Object[] objectArray2 = sA;
        int n3 = sA.length;
        n = 0;
        while (n < n3) {
            Object name3 = objectArray2[n];
            s = (String)mMap.get(name3);
            m.append(s).append(" = ");
            clearList.append(" ").append(s);
            s = CompiledRate.toString(this.sbaRates.get(name3));
            s = SBAtoISBJava.sanitiseExpression(s, mMap);
            m.append(s);
            m.append(";").append(" % ").append((String)name3).append(term);
            ++n;
        }
        m.append(term).append("% non-zero components").append(term);
        sA = new String[this.sbaPopulations.size()];
        this.sbaPopulations.keySet().toArray(sA);
        Arrays.sort(sA);
        int i2 = 1;
        HashSet<Object> nonZero = new HashSet<Object>();
        Object[] objectArray3 = sA;
        int n4 = sA.length;
        int n5 = 0;
        while (n5 < n4) {
            Object name4 = objectArray3[n5];
            double d = this.sbaPopulations.get(name4).doubleValue();
            if (d != 0.0) {
                s = (String)mMap.get(name4);
                if (cMap.containsKey(s)) {
                    int n6 = (Integer)cMap.get(s);
                    cMap.put(s, n6 + 1);
                    s = String.valueOf(s) + Integer.toString(n6);
                    mMap.put((String)name4, s);
                }
                m.append(s).append(" = ").append(d);
                m.append(";").append(" % ").append((String)name4).append(term);
                nonZero.add(name4);
                clearList.append(" ").append(s);
            }
            ++n5;
        }
        clearList.append(" ").append(functionName).append(";");
        m.append(term);
        sA = this.model.getOrderedSpeciesNamesArray();
        HashMap<Object, Integer> speciesIndex = new HashMap<Object, Integer>();
        m.append("% ");
        boolean bl = false;
        while (var9_24 < sA.length) {
            speciesIndex.put(sA[var9_24], (int)var9_24);
            m.append((String)sA[var9_24]).append(" ");
            ++var9_24;
        }
        m.deleteCharAt(m.length() - 1);
        m.append(term);
        m.append("y = [");
        Object[] objectArray4 = sA;
        int n7 = sA.length;
        n4 = 0;
        while (n4 < n7) {
            Object name5 = objectArray4[n4];
            if (nonZero.contains(name5)) {
                m.append((String)mMap.get(name5));
            } else {
                m.append("0.0");
            }
            m.append(" ");
            mMap.put((String)name5, "y(" + i2++ + ")");
            ++n4;
        }
        m.deleteCharAt(m.length() - 1);
        m.append("];").append(term).append(term);
        StringBuilder[] odesSB = new StringBuilder[sA.length];
        ArrayList[] odesAL = new ArrayList[sA.length];
        boolean bl2 = false;
        while (var9_26 < sA.length) {
            odesSB[var9_26] = new StringBuilder();
            odesAL[var9_26] = new ArrayList();
            ++var9_26;
        }
        for (SBAReaction sbar : this.sbaReactions) {
            int n8;
            int index;
            CompiledRate rate = this.apparentRate ? this.getApparentRate(sbar) : this.getMassActionRate(sbar);
            String rateString = rate.toString();
            if (this.apparentRate && !rate.isExpression()) {
                for (SBAComponent sbac : sbar.reactants) {
                    rateString = sbac.stoichiometry > 1 ? String.valueOf(rateString) + "*(" + sbac.name + "^" + sbac.stoichiometry + ")" : String.valueOf(rateString) + "*" + sbac.name;
                }
            }
            rateString = SBAtoISBJava.sanitiseExpression(rateString, mMap);
            s = " + " + rateString;
            for (SBAComponent sbac : sbar.reactants) {
                index = (Integer)speciesIndex.get(sbac.name);
                n8 = odesAL[index].indexOf(s);
                if (n8 == -1) {
                    odesAL[index].add(" - " + rateString);
                    continue;
                }
                odesAL[index].remove(n8);
            }
            s = " - " + rateString;
            for (SBAComponent sbac : sbar.products) {
                index = (Integer)speciesIndex.get(sbac.name);
                n8 = odesAL[index].indexOf(s);
                if (n8 == -1) {
                    odesAL[index].add(" + " + rateString);
                    continue;
                }
                odesAL[index].remove(n8);
            }
        }
        int n9 = odesSB.length - 1;
        while (var9_29 >= 0) {
            for (String entry : odesAL[var9_29]) {
                odesSB[var9_29].append(entry);
            }
            if (odesSB[var9_29].length() == 0) {
                odesSB[var9_29].append("0");
            }
            --var9_29;
        }
        m.append(functionName).append(" = @(t,y) [");
        if (odesSB[0].length() > 3 && odesSB[0].substring(0, 3).equals(" + ")) {
            odesSB[0].delete(0, 3);
        } else if (odesSB[0].length() > 3 && odesSB[0].substring(0, 3).equals(" - ")) {
            odesSB[0].replace(0, 3, "-");
        }
        m.append(odesSB[0].toString()).append(";...").append(term);
        boolean bl3 = true;
        while (var9_31 < odesSB.length) {
            if (odesSB[var9_31].length() > 3 && odesSB[var9_31].substring(0, 3).equals(" + ")) {
                odesSB[var9_31].delete(0, 3);
            } else if (odesSB[var9_31].length() > 3 && odesSB[var9_31].substring(0, 3).equals(" - ")) {
                odesSB[var9_31].replace(0, 3, "-");
            }
            m.append("                          ").append(odesSB[var9_31].toString());
            if (var9_31 == odesSB.length - 1) {
                m.append("];").append(term).append(term);
            } else {
                m.append(";...").append(term);
            }
            ++var9_31;
        }
        m.append("[t,y] = ode15s(").append(functionName).append(",[");
        m.append(this.startTime).append(",");
        if (this.stopTime == this.startTime) {
            m.append(OptionsMap.Parameter.Stop_Time.getDefault());
        } else {
            m.append(this.stopTime);
        }
        m.append("],y);").append(term).append(term);
        m.append((CharSequence)clearList);
        return m.toString();
    }

    private static String matlabName(String name) {
        StringBuilder sb = new StringBuilder(name);
        if (name.startsWith("\"") && name.endsWith("\"")) {
            char[] cArray = name.substring(1, name.length() - 1).toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isLetterOrDigit(c)) break;
                sb.append(c);
                ++n2;
            }
        }
        return sb.insert(0, "P_").toString();
    }

    private static final String sanitiseExpression(String expression, Map<String, String> mMap) {
        String s;
        ArrayList<String> splitString = new ArrayList<String>();
        String[] sA = expression.split("\"");
        int i = 0;
        if (!expression.startsWith("\"")) {
            ++i;
        }
        while (i < sA.length) {
            sA[i] = mMap.get("\"" + sA[i] + "\"");
            i += 2;
        }
        String[] stringArray = sA;
        int n = sA.length;
        int n2 = 0;
        while (n2 < n) {
            String s1 = stringArray[n2];
            splitString.add(s1);
            ++n2;
        }
        String delim2 = null;
        String[] stringArray2 = new String[]{"\\+", "-", "\\*", "/", "\\(", ",", "\\)", "^"};
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String delim = stringArray2[n];
            delim2 = delim.length() > 1 ? delim.substring(delim.length() - 1, delim.length()) : delim;
            i = 0;
            while (i < splitString.size()) {
                s = (String)splitString.get(i);
                sA = s.split(delim);
                if (sA.length > 1 || sA[0].length() != s.length()) {
                    splitString.remove(i);
                    splitString.add(i++, sA[0]);
                    int i3 = 1;
                    while (i3 < sA.length) {
                        splitString.add(i++, delim2);
                        splitString.add(i++, sA[i3]);
                        ++i3;
                    }
                    while (s.endsWith(delim2)) {
                        splitString.add(i++, delim2);
                        s = s.substring(0, s.length() - delim2.length());
                    }
                    --i;
                }
                ++i;
            }
            ++n;
        }
        i = 0;
        while (i < splitString.size()) {
            s = (String)splitString.get(i);
            if (mMap.containsKey(s)) {
                splitString.remove(i);
                splitString.add(i, mMap.get(s));
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        for (String s1 : splitString) {
            sb.append(s1);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Algorithm {
        GIBSON_BRUCK("Gibson-Bruck Stochastic Algorithm", SimulatorStochasticGibsonBruck.class, OptionsMap.Solver.Gibson_Bruck),
        GILLESPIE("Gillespies Stochastic Algorithm", SimulatorStochasticGillespie.class, OptionsMap.Solver.Gillespie),
        ODE_DOPR54_ADAPTIVE("Adaptive step-size 5th-order Dormand Prince ODE Solver", SimulatorOdeToJavaRungeKuttaAdaptive.class, OptionsMap.Solver.DOPR),
        ODE_IMEX443_STIFF("Implicit-Explicit Runge Kutta ODE Solver", SimulatorOdeToJavaRungeKuttaImplicit.class, OptionsMap.Solver.IMEX);

        OptionsMap.Solver mapping;
        String name;
        Class<?> simulatorClass;

        public static Algorithm getAlgorithm(OptionsMap.Solver solver) {
            Algorithm[] algorithmArray = Algorithm.values();
            int n = algorithmArray.length;
            int n2 = 0;
            while (n2 < n) {
                Algorithm algorithm = algorithmArray[n2];
                if (algorithm.mapping.equals((Object)solver)) {
                    return algorithm;
                }
                ++n2;
            }
            return null;
        }

        private Algorithm(String name, Class<?> simulatorClass, OptionsMap.Solver mapping) {
            this.name = name;
            this.simulatorClass = simulatorClass;
            this.mapping = mapping;
        }

        Simulator getSimulator() throws SBASimulatorException {
            try {
                return (Simulator)this.simulatorClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new SBASimulatorException("Error constructing " + this.name + ". Cannot find class.", e);
            }
            catch (IllegalAccessException e) {
                throw new SBASimulatorException("Error constructing " + this.name + ". Cannot find class.", e);
            }
        }

        SimulatorParameters getSimulatorParameters(Simulator simulator) throws SBASimulatorException {
            try {
                Class<?> c = this.simulatorClass.getSuperclass();
                Method m = c.getMethod("getDefaultSimulatorParameters", new Class[0]);
                return (SimulatorParameters)m.invoke(c.cast(simulator), new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new SBASimulatorException("Error retrieving parameters for " + this.name + ". Cannot find class.", e);
            }
            catch (IllegalAccessException e) {
                throw new SBASimulatorException("Error retrieving parameters for " + this.name + ". Cannot find class.", e);
            }
            catch (InvocationTargetException e) {
                throw new SBASimulatorException("Error retrieving parameters for " + this.name + ". Cannot find class.", e.getCause());
            }
        }

        void initializeSimulator(Simulator simulator, Model model) throws SBASimulatorException {
            try {
                Method m = this.simulatorClass.getMethod("initialize", Model.class);
                m.invoke((Object)simulator, model);
            }
            catch (NoSuchMethodException e) {
                throw new SBASimulatorException("Error initializing " + this.name + ". Cannot find class.", e);
            }
            catch (IllegalArgumentException e) {
                throw new SBASimulatorException("Error initializing " + this.name + ". Ensure model is correct.", e);
            }
            catch (IllegalAccessException e) {
                throw new SBASimulatorException("Error initializing " + this.name, e);
            }
            catch (InvocationTargetException e) {
                throw new SBASimulatorException("Error initializing " + this.name + ". Ensure model is correct.", e.getCause());
            }
        }

        SimulationResults simulate(Simulator simulator, double startTime, double stopTime, SimulatorParameters simulatorParameters, int numberofSamples, String[] trackedSpecies) throws SBASimulatorException {
            try {
                Class<?> c = this.simulatorClass.getSuperclass();
                Method m = c.getMethod("simulate", Double.TYPE, Double.TYPE, SimulatorParameters.class, Integer.TYPE, new String[0].getClass());
                return (SimulationResults)m.invoke(c.cast(simulator), startTime, stopTime, simulatorParameters, numberofSamples, trackedSpecies);
            }
            catch (NoSuchMethodException e) {
                throw new SBASimulatorException("Error running simulation for " + this.name + ". Cannot find class.", e);
            }
            catch (IllegalArgumentException e) {
                throw new SBASimulatorException("Error running simulation.", e);
            }
            catch (IllegalAccessException e) {
                throw new SBASimulatorException("Error running simulation.", e);
            }
            catch (InvocationTargetException e) {
                throw new SBASimulatorException("Error running simulation. " + e.getCause().getMessage(), e.getCause());
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

