/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tests;

import fern.network.Network;
import fern.simulation.Simulator;
import fern.simulation.algorithm.GillespieEnhanced;
import fern.simulation.observer.Observer;
import java.io.IOException;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.largescale.IParametricDerivationGraph;
import uk.ac.ed.inf.pepa.largescale.ParametricDerivationGraphBuilder;
import uk.ac.ed.inf.pepa.largescale.simulation.PEPANetwork;
import uk.ac.ed.inf.pepa.ode.DifferentialAnalysisException;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.sba.PEPAtoSBA;
import uk.ac.ed.inf.pepa.sba.SBAParseException;
import uk.ac.ed.inf.pepa.sba.SBASimulatorException;
import uk.ac.ed.inf.pepa.sba.SBAtoISBJava;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class SimulationComparison {
    public static void main(String[] args) throws IOException, DifferentialAnalysisException, InterruptedException, SBAParseException, SBASimulatorException {
        ModelNode model = (ModelNode)PepaTools.parse(PepaTools.readText(args[0]));
        long timeFERN = 0L;
        long timeDIZZY = 0L;
        int i = 0;
        while (i < 5) {
            timeFERN += SimulationComparison.simulateFERN(model);
            ++i;
        }
        System.out.println("FERN: " + timeFERN);
        System.out.println("DIZZY: " + timeDIZZY);
    }

    private static long simulateFERN(ModelNode model) throws DifferentialAnalysisException, InterruptedException {
        IParametricDerivationGraph derivationGraph = ParametricDerivationGraphBuilder.createDerivationGraph(model, null);
        PEPANetwork net = new PEPANetwork(derivationGraph);
        GillespieEnhanced sim = new GillespieEnhanced((Network)net);
        Observer observer = new Observer((Simulator)sim, (Simulator)sim){
            private final /* synthetic */ Simulator val$sim;
            {
                this.val$sim = simulator;
                super($anonymous0);
            }

            public void activateReaction(int mu, double tau, Simulator.FireType fireType, int times) {
            }

            public void finished() {
            }

            public void started() {
                this.setTheta(0.0);
            }

            public void step() {
            }

            public void theta(double theta) {
                System.out.println(String.valueOf(theta) + " : " + this.val$sim.getAmount(3));
                this.setTheta(theta + 1.0);
            }
        };
        sim.addObserver(observer);
        long tic = System.currentTimeMillis();
        sim.start(30.0);
        long toc = System.currentTimeMillis();
        System.out.println("Partial FERN: " + (toc - tic));
        return toc - tic;
    }

    private static long simulateDIZZY(ModelNode model) throws SBAParseException, SBASimulatorException {
        OptionsMap map = new OptionsMap();
        map.setValue(OptionsMap.Parameter.Components, new String[]{"PServer_Exe"});
        map.setValue(OptionsMap.Parameter.Solver, (Object)OptionsMap.Solver.Gillespie);
        map.setValue(OptionsMap.Parameter.Start_Time, 0.0);
        map.setValue(OptionsMap.Parameter.Stop_Time, 30.0);
        map.setValue(OptionsMap.Parameter.Independent_Replications, 1);
        PEPAtoSBA p2s = new PEPAtoSBA(model);
        p2s.parseModel();
        SBAtoISBJava modelSBA = new SBAtoISBJava(p2s);
        modelSBA.generateISBJavaModel("name", true);
        modelSBA.initialiseSimulator(map);
        long tic = System.currentTimeMillis();
        modelSBA.runModel();
        long toc = System.currentTimeMillis();
        System.out.println("Partial DIZZY: " + (toc - tic));
        return toc - tic;
    }
}

