/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tests;

import java.io.IOException;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class SteadyStateAnalysis {
    public static void main(String[] args) throws IOException, DerivationException {
        String fileName = args[0];
        ModelNode modelNode = (ModelNode)PepaTools.parse(PepaTools.readText(fileName));
        IStateSpace stateSpace = PepaTools.derive(new OptionMap(), modelNode, null, null);
        int i = 0;
        while (i < stateSpace.size()) {
            int[] targetStateIndices;
            String source = SteadyStateAnalysis.getProcessString(stateSpace, i);
            int[] nArray = targetStateIndices = stateSpace.getOutgoingStateIndices(i);
            int n = targetStateIndices.length;
            int n2 = 0;
            while (n2 < n) {
                int target = nArray[n2];
                StringBuffer message = new StringBuffer();
                message.append(source);
                message.append(" --> ");
                message.append(SteadyStateAnalysis.getProcessString(stateSpace, target));
                message.append(" via ");
                String[] stringArray = stateSpace.getAction(i, target);
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String action = stringArray[n4];
                    message.append(String.valueOf(action) + " ");
                    ++n4;
                }
                System.out.println(message.toString());
                ++n2;
            }
            ++i;
        }
    }

    private static String getProcessString(IStateSpace stateSpace, int stateIndex) {
        StringBuffer buf = new StringBuffer();
        String separator = " | ";
        int i = 0;
        while (i < stateSpace.getMaximumNumberOfSequentialComponents()) {
            buf.append(stateSpace.getLabel(stateIndex, i));
            if (i < stateSpace.getMaximumNumberOfSequentialComponents() - 1) {
                buf.append(separator);
            }
            ++i;
        }
        return buf.toString();
    }
}

