/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.sba.Results;
import uk.ac.ed.inf.pepa.sba.SBAtoISBJava;

public class TestCMDL {
    private static String[] rules = new String[]{"User0", "User1", "EnterBuilding0", "EnterBuilding1", "AC_DO_ADMIT1", "AC11", "AC3"};
    private static double start = 0.0;
    private static double stop = 1000.0;
    private static int datapoints = 100;

    public static void main(String[] args) throws IOException {
        System.out.println("Reading file: " + args[0]);
        TestCMDL.dothejob(args[0]);
    }

    private static String readText(String fileName) throws IOException {
        String result = null;
        if (fileName != null) {
            File file = new File(fileName);
            StringBuffer sb = new StringBuffer();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                String lineSearator = System.getProperty("line.separator");
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(lineSearator);
                }
                result = sb.toString();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                    }
                }
            }
        }
        return result;
    }

    private static void dothejob(String modelName) throws IOException {
        OptionsMap map = new OptionsMap();
        map.setValue(OptionsMap.Parameter.Components, rules);
        map.setValue(OptionsMap.Parameter.Solver, (Object)OptionsMap.Solver.DOPR);
        map.setValue(OptionsMap.Parameter.Absolute_Error, 1.0E-5);
        map.setValue(OptionsMap.Parameter.Relative_Error, 1.0E-5);
        map.setValue(OptionsMap.Parameter.Start_Time, start);
        map.setValue(OptionsMap.Parameter.Stop_Time, stop);
        map.setValue(OptionsMap.Parameter.Data_Points, datapoints);
        String cmdlModel = TestCMDL.readText(modelName);
        int[] experiments = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 40, 50, 100, 200};
        long[] elapsed = new long[experiments.length];
        double[][] results = new double[experiments.length][rules.length];
        int i = 0;
        while (i < experiments.length) {
            System.out.println("******");
            System.out.println("Experiment " + (i + 1) + " Users=" + experiments[i]);
            System.out.println("******");
            String prefix = "USERS = " + experiments[i] + ";\n";
            try {
                SBAtoISBJava modelSBA = SBAtoISBJava.generateModel(String.valueOf(prefix) + cmdlModel);
                modelSBA.initialiseSimulator(map);
                Results r = null;
                long tic = System.currentTimeMillis();
                r = modelSBA.runModel();
                long toc = System.currentTimeMillis();
                elapsed[i] = toc - tic;
                System.out.println("Elapsed: " + elapsed[i]);
                int lastTimePoint = r.getSimpleTimeSeries().length - 1;
                int numberOfElements = r.getSimpleTimeSeries()[lastTimePoint].length;
                int j = 1;
                while (j < numberOfElements) {
                    String species = r.getSpeciesOrdering()[j - 1];
                    double value = r.getSimpleTimeSeries()[lastTimePoint][j];
                    System.out.print(String.valueOf(species) + " : ");
                    System.out.println(value);
                    results[i][j - 1] = value;
                    ++j;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        System.gc();
        long average = 0L;
        long[] lArray = elapsed;
        int n = elapsed.length;
        int n2 = 0;
        while (n2 < n) {
            long el = lArray[n2];
            average += el;
            ++n2;
        }
        System.out.println("***");
        System.out.println("Average Execution time: " + (double)average / (double)experiments.length);
        System.out.println("***");
        System.out.print("#");
        String[] stringArray = rules;
        n2 = rules.length;
        int r = 0;
        while (r < n2) {
            String rule = stringArray[r];
            System.out.print(String.valueOf(rule) + ",");
            ++r;
        }
        System.out.println();
        int k = 0;
        while (k < results.length) {
            int z = 0;
            while (z < rules.length) {
                System.out.print(String.valueOf(results[k][z]) + (z == rules.length - 1 ? "" : ","));
                ++z;
            }
            System.out.println();
            ++k;
        }
    }
}

