/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.derivation.common.StateSpaceBuilderFactory;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverFactory;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class TestFilter {
    public static void main(String[] args) throws IOException {
        ModelNode model = (ModelNode)PepaTools.parse(TestFilter.readText(args[0]));
        IProblem[] iProblemArray = model.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem p = iProblemArray[n2];
            if (p.isError()) {
                System.err.println(p.getMessage());
                System.exit(1);
            }
            ++n2;
        }
        OptionMap map = new OptionMap();
        map.put("ctmc.steadystate.solver", 4);
        map.put("ctmc.derivation.aggregate_arrays", true);
        map.put("ctmc.derivation.storage", 0);
        IStateSpaceBuilder builder = StateSpaceBuilderFactory.createStateSpaceBuilder(model, map, null);
        try {
            IStateSpace ss = builder.derive(false, null);
            ISolver solver = SolverFactory.createSolver(ss, map);
            solver.solve(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readText(String fileName) throws IOException {
        String result = null;
        if (fileName != null) {
            File file = new File(fileName);
            StringBuffer sb = new StringBuffer();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                String lineSearator = System.getProperty("line.separator");
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(lineSearator);
                }
                result = sb.toString();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                    }
                }
            }
        }
        return result;
    }
}

