/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import uk.ac.ed.inf.pepa.parsing.ASTVisitor;
import uk.ac.ed.inf.pepa.parsing.ActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.Actions;
import uk.ac.ed.inf.pepa.parsing.ActivityNode;
import uk.ac.ed.inf.pepa.parsing.AggregationNode;
import uk.ac.ed.inf.pepa.parsing.BinaryOperatorRateNode;
import uk.ac.ed.inf.pepa.parsing.ChoiceNode;
import uk.ac.ed.inf.pepa.parsing.ConstantProcessNode;
import uk.ac.ed.inf.pepa.parsing.CooperationNode;
import uk.ac.ed.inf.pepa.parsing.HidingNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.parsing.PassiveRateNode;
import uk.ac.ed.inf.pepa.parsing.PrefixNode;
import uk.ac.ed.inf.pepa.parsing.ProcessDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDefinitionNode;
import uk.ac.ed.inf.pepa.parsing.RateDoubleNode;
import uk.ac.ed.inf.pepa.parsing.UnknownActionTypeNode;
import uk.ac.ed.inf.pepa.parsing.VariableRateNode;
import uk.ac.ed.inf.pepa.parsing.WildcardCooperationNode;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class Latexifier {
    private StringBuffer buf;
    private ModelNode node;
    private boolean isSetsOnSeparateLines = false;
    private double spaceBetweenSections = 2.0;
    private String setName = "S";
    private int setCount = 1;
    private LinkedList<SyncSet> sets = new LinkedList();
    private final String sep = System.getProperty("line.separator");

    public Latexifier(ModelNode node) {
        this.node = node;
    }

    public void setLabel(String s) {
        if (s == null || s.equals("")) {
            throw new IllegalArgumentException();
        }
        this.setName = s;
    }

    public String getLabel() {
        return this.setName;
    }

    public void setExtraSpace(double value) {
        this.spaceBetweenSections = value;
    }

    public double getExtraSpace() {
        return this.spaceBetweenSections;
    }

    public boolean isSetsOnSeparateLines() {
        return this.isSetsOnSeparateLines;
    }

    public void setSetsOnSeparateLines(boolean value) {
        this.isSetsOnSeparateLines = value;
    }

    public String getLatexSource() {
        this.buf = new StringBuffer();
        String initMessage = "% Automatically generated by PEPA2Latex" + this.sep + "% --begin" + this.sep;
        this.buf.append(initMessage);
        this.buf.append("\\begin{displaymath}" + this.sep + "\t" + "\\begin{array}{rcl}" + this.sep);
        this.node.accept(new LatexVisitor());
        this.buf.append("% --end");
        return this.buf.toString();
    }

    public static void main(String[] args) throws IOException {
        ModelNode model = (ModelNode)PepaTools.parse(Latexifier.readText(args[0]));
        Latexifier pepa2latex = new Latexifier(model);
        System.err.println(pepa2latex.getLatexSource());
        PrintWriter pw = null;
        pw = new PrintWriter(args[1]);
        pw.print(pepa2latex.getLatexSource());
        pw.close();
    }

    private static String readText(String fileName) throws IOException {
        String result = null;
        if (fileName != null) {
            File file = new File(fileName);
            StringBuffer sb = new StringBuffer();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                String lineSearator = System.getProperty("line.separator");
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(lineSearator);
                }
                result = sb.toString();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                    }
                }
            }
        }
        return result;
    }

    private class LatexVisitor
    implements ASTVisitor {
        private LatexVisitor() {
        }

        public void visitActivityNode(ActivityNode activity) {
            Latexifier.this.buf.append("(");
            activity.getAction().accept(this);
            Latexifier.this.buf.append(",");
            activity.getRate().accept(this);
            Latexifier.this.buf.append(")");
        }

        public void visitActionTypeNode(ActionTypeNode actionType) {
            this.mathIt(actionType.getType());
        }

        public void visitChoiceNode(ChoiceNode choice) {
            choice.getLeft().accept(this);
            Latexifier.this.buf.append("+");
            choice.getRight().accept(this);
        }

        public void visitConstantProcessNode(ConstantProcessNode constant) {
            this.mathIt(constant.getName());
        }

        public void visitCooperationNode(CooperationNode cooperation) {
            cooperation.getLeft().accept(this);
            if (cooperation.getActionSet().size() == 0) {
                Latexifier.this.buf.append("\\parallel");
            } else {
                Latexifier.this.buf.append("\\sync{" + this.actionSet(cooperation.getActionSet()) + "}");
            }
            cooperation.getRight().accept(this);
        }

        public void visitHidingNode(HidingNode hiding) {
            hiding.getProcess().accept(this);
            Latexifier.this.buf.append("/");
            Latexifier.this.buf.append("\\lbrace" + this.actionSet(hiding.getActionSet()) + "\\rbrace");
        }

        private String actionSet(Actions actionSet) {
            StringBuffer as = new StringBuffer();
            for (ActionTypeNode action : actionSet) {
                as.append(String.valueOf(action.getType()) + ",");
            }
            as.deleteCharAt(as.length() - 1);
            if (!Latexifier.this.isSetsOnSeparateLines) {
                return as.toString();
            }
            SyncSet newSet = new SyncSet();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Latexifier.this.setName)).append("_{");
            Latexifier latexifier = Latexifier.this;
            int n = latexifier.setCount;
            latexifier.setCount = n + 1;
            newSet.name = stringBuilder.append(n).append("}").toString();
            newSet.value = as.toString();
            Latexifier.this.sets.add(newSet);
            return newSet.name;
        }

        public void visitModelNode(ModelNode model) {
            for (RateDefinitionNode rateDef : model.rateDefinitions()) {
                Latexifier.this.buf.append("\t\t");
                rateDef.accept(this);
            }
            Latexifier.this.buf.append("[" + Latexifier.this.spaceBetweenSections + "ex]");
            for (ProcessDefinitionNode procDef : model.processDefinitions()) {
                Latexifier.this.buf.append("\t\t");
                procDef.accept(this);
            }
            Latexifier.this.buf.append("[" + Latexifier.this.spaceBetweenSections + "ex]");
            Latexifier.this.buf.append("\t\t\\multicolumn{3}{l}{");
            model.getSystemEquation().accept(this);
            Latexifier.this.buf.append("}");
            Latexifier.this.buf.append("\\\\" + Latexifier.this.sep);
            Latexifier.this.buf.append("[" + Latexifier.this.spaceBetweenSections + "ex]");
            if (Latexifier.this.isSetsOnSeparateLines) {
                this.handleSets();
            }
            Latexifier.this.buf.append("\t\\end{array}" + Latexifier.this.sep + "\\end{displaymath}" + Latexifier.this.sep);
        }

        private void handleSets() {
            for (SyncSet set : Latexifier.this.sets) {
                Latexifier.this.buf.append("\t\t" + set.name + " & = & \\lbrace " + set.value + "\\rbrace\\\\" + Latexifier.this.sep);
            }
        }

        public void visitPassiveRateNode(PassiveRateNode passive) {
            if (passive.getMultiplicity() != 1) {
                Latexifier.this.buf.append(String.valueOf(passive.getMultiplicity()) + "\\cdot");
            }
            Latexifier.this.buf.append("\\top");
        }

        public void visitPrefixNode(PrefixNode prefix) {
            prefix.getActivity().accept(this);
            Latexifier.this.buf.append(".");
            prefix.getTarget().accept(this);
        }

        public void visitProcessDefinitionNode(ProcessDefinitionNode processDefinition) {
            this.mathIt(processDefinition.getName().getName());
            this.and();
            processDefinition.getNode().accept(this);
            Latexifier.this.buf.append("\\\\" + Latexifier.this.sep);
        }

        public void visitRateDefinitionNode(RateDefinitionNode rateDefinition) {
            this.mathIt(rateDefinition.getName().getName());
            Latexifier.this.buf.append(" & = & ");
            rateDefinition.getRate().accept(this);
            Latexifier.this.buf.append("\\\\" + Latexifier.this.sep);
        }

        public void visitRateDoubleNode(RateDoubleNode doubleRate) {
            Latexifier.this.buf.append(String.valueOf(doubleRate.getValue()));
        }

        public void visitVariableRateNode(VariableRateNode variableRate) {
            this.mathIt(variableRate.getName());
        }

        public void visitBinaryOperatorRateNode(BinaryOperatorRateNode rate) {
            rate.getLeft().accept(this);
            Latexifier.this.buf.append(rate.getOperator().toString());
            rate.getRight().accept(this);
        }

        public void visitAggregationNode(AggregationNode aggregation) {
            aggregation.getProcessNode().accept(this);
            Latexifier.this.buf.append("[");
            aggregation.getCopies().accept(this);
            Latexifier.this.buf.append("]");
        }

        private void mathIt(String string) {
            Latexifier.this.buf.append("\\mathit{" + string + "}");
        }

        private void and() {
            Latexifier.this.buf.append(" & \\rmdef & ");
        }

        public void visitUnknownActionTypeNode(UnknownActionTypeNode unknownActionTypeNode) {
            Latexifier.this.buf.append("\tau");
        }

        public void visitWildcardCooperationNode(WildcardCooperationNode cooperation) {
            cooperation.getLeft().accept(this);
            Latexifier.this.buf.append("\\sync{*}");
            cooperation.getRight().accept(this);
        }
    }

    private class SyncSet {
        public String name;
        public String value;

        private SyncSet() {
        }
    }
}

